/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter.visitor;

import org.camunda.community.migration.converter.DomElementVisitorContext;
import org.camunda.community.migration.converter.exception.VisitorException;
import org.camunda.community.migration.converter.visitor.DomElementVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFilteringVisitor
implements DomElementVisitor {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());

    @Override
    public void visit(DomElementVisitorContext context) {
        try {
            if (this.canVisit(context)) {
                this.logVisit(context);
                this.visitFilteredElement(context);
            }
        }
        catch (Exception e) {
            VisitorException visitorException = new VisitorException(this.getClass(), context.getElement(), e);
            context.notify(visitorException);
            this.LOG.error("Exception while visiting an element", visitorException);
        }
    }

    protected abstract void visitFilteredElement(DomElementVisitorContext var1);

    protected abstract boolean canVisit(DomElementVisitorContext var1);

    protected void logVisit(DomElementVisitorContext context) {
        this.LOG.debug("Visiting {}:{}", (Object)context.getElement().getPrefix(), (Object)context.getElement().getLocalName());
    }
}

