/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter.cli;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.community.migration.converter.cli.AbstractConvertCommand;
import org.camunda.community.migration.converter.cli.ProcessDefinitionDto;
import org.camunda.community.migration.converter.cli.ProcessEngineClient;
import picocli.CommandLine;

@CommandLine.Command(name="engine", description={"Converts the diagrams from the given process engine"}, mixinStandardHelpOptions=true)
public class ConvertEngineCommand
extends AbstractConvertCommand {
    private static final String DEFAULT_URL = "http://localhost:8080/engine-rest";
    @CommandLine.Parameters(index="0", description={"Fully qualified http(s) address to the process engine REST API"}, defaultValue="http://localhost:8080/engine-rest")
    String url = "http://localhost:8080/engine-rest";
    @CommandLine.Option(names={"-u", "--username"}, description={"Username for basic auth"})
    String username;
    @CommandLine.Option(names={"-p", "--password"}, description={"Password for basic auth"})
    String password;
    @CommandLine.Option(names={"-t", "--target-directory"}, description={"The directory to save the .bpmn files"}, defaultValue=".")
    File targetDirectory = new File(".");

    @Override
    protected File targetDirectory() {
        return this.targetDirectory;
    }

    @Override
    protected Map<File, BpmnModelInstance> modelInstances() {
        Map<String, Map<String, Set<String>>> allLatestBpmnXml = this.getAllLatestBpmnXml();
        HashMap<File, BpmnModelInstance> result = new HashMap<File, BpmnModelInstance>();
        allLatestBpmnXml.forEach((resourceName, models) -> models.forEach((model, processDefinitionKeys) -> {
            String filename = models.size() == 1 ? resourceName : FilenameUtils.getBaseName(resourceName) + " (" + String.join((CharSequence)", ", processDefinitionKeys) + ")." + FilenameUtils.getExtension(resourceName);
            result.put(new File(this.targetDirectory, filename), Bpmn.readModelFromStream(new ByteArrayInputStream(model.getBytes())));
        }));
        return result;
    }

    private Map<String, Map<String, Set<String>>> getAllLatestBpmnXml() {
        ProcessEngineClient client = ProcessEngineClient.withEngine(this.url, this.username, this.password);
        return client.getAllLatestProcessDefinitions().stream().collect(Collectors.groupingBy(ProcessDefinitionDto::getResource, Collectors.groupingBy(pd -> client.getBpmnXml(pd.getId()).getBpmn20Xml(), Collectors.mapping(ProcessDefinitionDto::getKey, Collectors.toSet()))));
    }
}

