/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter;

import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryTimeCycleConverter {
    private static final Logger LOG = LoggerFactory.getLogger(RetryTimeCycleConverter.class);
    private static final Pattern PATTERN = Pattern.compile("R(\\d*)/");
    private static final Pattern DURATION_PATTERN = Pattern.compile("(P.*)");

    public static List<String> convert(String timecycle) {
        ArrayList<String> durations = new ArrayList<String>();
        CharSequence[] expressions = (String[])Arrays.stream(timecycle.split(",")).map(String::trim).toArray(String[]::new);
        LOG.debug("Found expressions: ['{}']", (Object)String.join((CharSequence)"','", expressions));
        for (CharSequence expression : expressions) {
            LOG.debug("Handling expression {}", (Object)expression);
            int retries = 0;
            Matcher matcher = PATTERN.matcher(expression);
            while (matcher.find()) {
                retries = Integer.parseInt(matcher.group(1));
            }
            if (!matcher.lookingAt()) {
                ++retries;
            }
            Matcher duration = DURATION_PATTERN.matcher(expression);
            int appliedRetries = 0;
            while (duration.find()) {
                String group = duration.group(1);
                try {
                    Duration.parse(group);
                }
                catch (DateTimeParseException e) {
                    throw new IllegalStateException(e);
                }
                LOG.debug("Duration is {}", (Object)group);
                for (int i = 0; i < retries; ++i) {
                    durations.add(group);
                    ++appliedRetries;
                }
            }
            LOG.debug("Retries are {}", (Object)appliedRetries);
        }
        if (durations.isEmpty()) {
            throw new IllegalStateException("Did not find any valid duration expressions in '" + timecycle + "'");
        }
        return durations;
    }
}

