/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter.visitor;

import org.camunda.community.migration.converter.DomElementVisitorContext;
import org.camunda.community.migration.converter.message.Message;
import org.camunda.community.migration.converter.message.MessageFactory;
import org.camunda.community.migration.converter.version.SemanticVersion;
import org.camunda.community.migration.converter.visitor.AbstractElementVisitor;

public abstract class AbstractBpmnElementVisitor
extends AbstractElementVisitor {
    @Override
    protected final String namespaceUri() {
        return "http://www.omg.org/spec/BPMN/20100524/MODEL";
    }

    @Override
    protected final void visitFilteredElement(DomElementVisitorContext context) {
        this.visitBpmnElement(context);
        SemanticVersion availableFrom = this.availableFrom(context);
        if (availableFrom == null) {
            context.addMessage(this.cannotBeConvertedMessage(context));
        } else if (this.isNotSupportedInDesiredVersion(availableFrom, SemanticVersion.parse(context.getProperties().getPlatformVersion()))) {
            context.addMessage(this.supportedInFutureVersionMessage(context, availableFrom));
        }
    }

    protected final boolean isNotSupportedInDesiredVersion(SemanticVersion availableFrom, SemanticVersion desiredVersion) {
        return availableFrom.ordinal() > desiredVersion.ordinal();
    }

    protected abstract SemanticVersion availableFrom(DomElementVisitorContext var1);

    protected abstract void visitBpmnElement(DomElementVisitorContext var1);

    protected Message supportedInFutureVersionMessage(DomElementVisitorContext context, SemanticVersion availableFrom) {
        return MessageFactory.elementAvailableInFutureVersion(context.getElement().getLocalName(), context.getProperties().getPlatformVersion(), availableFrom.toString());
    }

    protected Message cannotBeConvertedMessage(DomElementVisitorContext context) {
        return MessageFactory.elementNotSupportedHint(context.getElement().getLocalName(), context.getProperties().getPlatformVersion());
    }
}

