/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter.message;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.camunda.community.migration.converter.BpmnDiagramCheckResult;
import org.camunda.community.migration.converter.message.Message;
import org.camunda.community.migration.converter.message.MessageTemplate;
import org.camunda.community.migration.converter.message.MessageTemplateProcessor;

public class MessageTemplateProvider {
    private static final String PROPERTY_MESSAGE = "message";
    private static final String PROPERTY_LINK = "link";
    private static final String PROPERTY_SEVERITY = "severity";
    private static final MessageTemplateProcessor MESSAGE_TEMPLATE_PROCESSOR = new MessageTemplateProcessor();
    private static final Map<String, MessageTemplate> MESSAGE_TEMPLATES;
    private static final List<String> BOOTSTRAP_ERRORS;

    private static boolean isBuildingBlock(String name) {
        return "template".equals(name.split("\\.")[0]);
    }

    private static boolean assertMandatoryEntries(Map<String, Map<String, String>> messagesTemplates) {
        boolean allFine = true;
        for (Map.Entry<String, Map<String, String>> e : messagesTemplates.entrySet()) {
            for (String property : Arrays.asList(PROPERTY_SEVERITY, PROPERTY_MESSAGE)) {
                if (e.getValue().containsKey(property)) continue;
                BOOTSTRAP_ERRORS.add("Message '" + e.getKey() + "' needs a property '" + property + "'");
                allFine = false;
            }
        }
        return allFine;
    }

    private static void assertMessageProperties(String messageName, Map<String, String> messageProperties, String property) {
        if (messageProperties.containsKey(property)) {
            BOOTSTRAP_ERRORS.add("Defined multiple properties " + property + " for message " + messageName);
        }
    }

    private static boolean assertName(String propertyName) {
        String[] split = propertyName.split("\\.");
        if (split.length != 2 || !Arrays.asList(PROPERTY_LINK, PROPERTY_MESSAGE, PROPERTY_SEVERITY).contains(split[1])) {
            BOOTSTRAP_ERRORS.add("Error while parsing message templates: Property '" + propertyName + "' needs to consist of <MESSAGE_NAME>.<" + String.join((CharSequence)"|", PROPERTY_LINK, PROPERTY_MESSAGE, PROPERTY_SEVERITY) + ">");
            return false;
        }
        return true;
    }

    private static boolean assertSeverity(String messageName, String severity) {
        try {
            BpmnDiagramCheckResult.Severity.valueOf(severity);
        }
        catch (IllegalArgumentException e) {
            BOOTSTRAP_ERRORS.add("Severity '" + severity + "' for message '" + messageName + "' is not defined. Please use one of '" + Arrays.stream(BpmnDiagramCheckResult.Severity.values()).map(Enum::name).collect(Collectors.joining("', '")) + "'");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageTemplate getMessageTemplate(String templateName) {
        MessageTemplate template;
        Map<String, MessageTemplate> map = MESSAGE_TEMPLATES;
        synchronized (map) {
            template = MESSAGE_TEMPLATES.get(templateName);
        }
        if (template == null) {
            throw new IllegalStateException("No template found for name '" + templateName + "'");
        }
        return template;
    }

    static {
        BOOTSTRAP_ERRORS = new ArrayList<String>();
        MESSAGE_TEMPLATES = new HashMap<String, MessageTemplate>();
        Properties loader = new Properties();
        try (InputStream in = Message.class.getClassLoader().getResourceAsStream("message-templates.properties");){
            loader.load(in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        HashMap<String, String> rawTemplates = new HashMap<String, String>();
        HashMap<String, Map<String, String>> messagesTemplates = new HashMap<String, Map<String, String>>();
        for (String name : loader.stringPropertyNames()) {
            if (MessageTemplateProvider.isBuildingBlock(name)) {
                String templateName = name.split("\\.")[1];
                rawTemplates.put(templateName, loader.getProperty(name));
                continue;
            }
            if (!MessageTemplateProvider.assertName(name)) continue;
            String[] split = name.split("\\.");
            String messageName2 = split[0];
            String property = split[1];
            if (property.equals(PROPERTY_MESSAGE)) {
                rawTemplates.put(messageName2, loader.getProperty(name));
            }
            if (property.equals(PROPERTY_SEVERITY) && !MessageTemplateProvider.assertSeverity(messageName2, loader.getProperty(name))) continue;
            Map messageProperties = messagesTemplates.computeIfAbsent(messageName2, s -> new HashMap());
            MessageTemplateProvider.assertMessageProperties(messageName2, messageProperties, property);
            messageProperties.put(property, loader.getProperty(name));
        }
        if (MessageTemplateProvider.assertMandatoryEntries(messagesTemplates)) {
            MESSAGE_TEMPLATE_PROCESSOR.replaceTemplates(rawTemplates);
            rawTemplates.forEach((messageName, template) -> {
                if (messagesTemplates.containsKey(messageName)) {
                    ((Map)messagesTemplates.get(messageName)).put(PROPERTY_MESSAGE, template);
                }
            });
            messagesTemplates.forEach((key, value) -> MESSAGE_TEMPLATES.put((String)key, new MessageTemplate(BpmnDiagramCheckResult.Severity.valueOf((String)value.get(PROPERTY_SEVERITY)), (String)value.get(PROPERTY_LINK), (String)value.get(PROPERTY_MESSAGE), MESSAGE_TEMPLATE_PROCESSOR.extractVariables((String)value.get(PROPERTY_MESSAGE)))));
        }
        if (!BOOTSTRAP_ERRORS.isEmpty()) {
            throw new IllegalArgumentException(BOOTSTRAP_ERRORS.size() + " Errors while parsing message templates: \n- " + String.join((CharSequence)"\n- ", BOOTSTRAP_ERRORS));
        }
    }
}

