/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter.visitor;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.camunda.community.migration.converter.DomElementVisitorContext;
import org.camunda.community.migration.converter.visitor.AbstractBpmnElementVisitor;

public abstract class AbstractEventDefinitionVisitor
extends AbstractBpmnElementVisitor {
    @Override
    protected final void visitBpmnElement(DomElementVisitorContext context) {
    }

    @Override
    protected String elementNameForMessage(DomElementVisitorContext context) {
        String fullEventName = "";
        if (!this.isInterrupting(context)) {
            fullEventName = fullEventName + "Non-interrupting ";
        }
        if (!this.isNotEventSubProcessStartEvent(context)) {
            fullEventName = fullEventName + "Event Sub Process ";
        }
        fullEventName = fullEventName + this.simpleEventName(context);
        fullEventName = fullEventName + " ";
        fullEventName = fullEventName + StringUtils.capitalize(context.getElement().getParentElement().getLocalName().replaceAll("([A-Z])", " $1"));
        return fullEventName;
    }

    protected String simpleEventName(DomElementVisitorContext context) {
        return StringUtils.capitalize(context.getElement().getLocalName().split("([A-Z])")[0]);
    }

    protected boolean isNotEventSubProcessStartEvent(DomElementVisitorContext context) {
        if (context.getElement().getParentElement().getLocalName().equals("startEvent")) {
            boolean triggeredByEvent = this.parseWithDefault(context.getElement().getParentElement().getParentElement().getAttribute("http://www.omg.org/spec/BPMN/20100524/MODEL", "triggeredByEvent"), false);
            return !triggeredByEvent;
        }
        return true;
    }

    protected boolean isInterrupting(DomElementVisitorContext context) {
        boolean isInterrupting = this.parseWithDefault(context.getElement().getParentElement().getAttribute("http://www.omg.org/spec/BPMN/20100524/MODEL", "isInterrupting"), true);
        boolean cancelActivity = this.parseWithDefault(context.getElement().getParentElement().getAttribute("http://www.omg.org/spec/BPMN/20100524/MODEL", "cancelActivity"), true);
        return isInterrupting && cancelActivity;
    }

    private boolean parseWithDefault(String bool, boolean defaultValue) {
        return Optional.ofNullable(bool).map(Boolean::parseBoolean).orElse(defaultValue);
    }
}

