/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.validation.zeebe;

import io.camunda.zeebe.model.bpmn.instance.EndEvent;
import io.camunda.zeebe.model.bpmn.instance.Error;
import io.camunda.zeebe.model.bpmn.instance.ErrorEventDefinition;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class ErrorEventDefinitionValidator
implements ModelElementValidator<ErrorEventDefinition> {
    private static final String ZEEBE_EXPRESSION_PREFIX = "=";

    @Override
    public Class<ErrorEventDefinition> getElementType() {
        return ErrorEventDefinition.class;
    }

    @Override
    public void validate(ErrorEventDefinition element, ValidationResultCollector validationResultCollector) {
        String errorCode;
        ModelElementInstance parentElement = element.getParentElement();
        Error error = element.getError();
        if (parentElement instanceof EndEvent) {
            if (error == null) {
                validationResultCollector.addError(0, "Must reference an error");
            } else {
                String errorCode2 = error.getErrorCode();
                if (errorCode2 == null || errorCode2.isEmpty()) {
                    validationResultCollector.addError(0, "ErrorCode must be present and not empty");
                }
            }
        } else if (error != null && (errorCode = error.getErrorCode()) != null && errorCode.startsWith(ZEEBE_EXPRESSION_PREFIX)) {
            validationResultCollector.addError(0, "The errorCode of the error catch event is not allowed to be an expression");
        }
    }
}

