/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.validation.zeebe;

import io.camunda.zeebe.model.bpmn.instance.Escalation;
import io.camunda.zeebe.model.bpmn.instance.EscalationEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.Process;
import io.camunda.zeebe.model.bpmn.instance.ThrowEvent;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.camunda.bpm.model.xml.impl.ModelInstanceImpl;
import org.camunda.bpm.model.xml.impl.util.ModelUtil;
import org.camunda.bpm.model.xml.instance.DomElement;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class EscalationValidator
implements ModelElementValidator<Escalation> {
    @Override
    public Class<Escalation> getElementType() {
        return Escalation.class;
    }

    @Override
    public void validate(Escalation element, ValidationResultCollector validationResultCollector) {
        if (this.isReferredByThrowEvent(element)) {
            this.validateEscalationCode(element, validationResultCollector);
        }
    }

    private void validateEscalationCode(Escalation element, ValidationResultCollector validationResultCollector) {
        if (element.getEscalationCode() == null || element.getEscalationCode().isEmpty()) {
            validationResultCollector.addError(0, "EscalationCode must be present and not empty");
        }
    }

    private boolean isReferredByThrowEvent(Escalation element) {
        Collection<ThrowEvent> throwEvents = this.getAllElementsByType(element, ThrowEvent.class);
        return throwEvents.stream().flatMap(i -> i.getEventDefinitions().stream()).anyMatch(e -> e instanceof EscalationEventDefinition && ((EscalationEventDefinition)e).getEscalation() == element);
    }

    private <T extends ModelElementInstance> Collection<T> getAllElementsByType(Escalation element, Class<T> type) {
        return element.getParentElement().getChildElementsByType(Process.class).stream().flatMap(p -> this.getAllElementsByTypeRecursive((ModelElementInstance)p, type).stream()).collect(Collectors.toList());
    }

    private <T extends ModelElementInstance> Collection<T> getAllElementsByTypeRecursive(ModelElementInstance element, Class<T> type) {
        Collection<T> result = element.getChildElementsByType(type);
        List<DomElement> childDomElements = element.getDomElement().getChildElements();
        Collection childModelElements = ModelUtil.getModelElementCollection(childDomElements, (ModelInstanceImpl)element.getModelInstance());
        result.addAll(childModelElements.stream().flatMap(child -> this.getAllElementsByTypeRecursive((ModelElementInstance)child, type).stream()).collect(Collectors.toList()));
        return result;
    }
}

