/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.validation.zeebe;

import io.camunda.zeebe.model.bpmn.instance.EventDefinition;
import io.camunda.zeebe.model.bpmn.instance.IntermediateCatchEvent;
import io.camunda.zeebe.model.bpmn.instance.LinkEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.MessageEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.SignalEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.TimerEventDefinition;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class IntermediateCatchEventValidator
implements ModelElementValidator<IntermediateCatchEvent> {
    private static final List<Class<? extends EventDefinition>> SUPPORTED_EVENTS = Arrays.asList(MessageEventDefinition.class, TimerEventDefinition.class, SignalEventDefinition.class, LinkEventDefinition.class);

    @Override
    public Class<IntermediateCatchEvent> getElementType() {
        return IntermediateCatchEvent.class;
    }

    @Override
    public void validate(IntermediateCatchEvent element, ValidationResultCollector validationResultCollector) {
        Collection<EventDefinition> eventDefinitions = element.getEventDefinitions();
        if (eventDefinitions.size() != 1) {
            validationResultCollector.addError(0, "Must have exactly one event definition");
        } else {
            TimerEventDefinition timerEventDefinition;
            EventDefinition eventDefinition = eventDefinitions.iterator().next();
            Class<?> type = eventDefinition.getClass();
            if (SUPPORTED_EVENTS.stream().noneMatch(c -> c.isAssignableFrom(type))) {
                validationResultCollector.addError(0, "Event definition must be one of: message, timer, signal, or link");
            } else if (eventDefinition instanceof TimerEventDefinition && (timerEventDefinition = (TimerEventDefinition)eventDefinition).getTimeDuration() == null && timerEventDefinition.getTimeDate() == null) {
                validationResultCollector.addError(0, "Intermediate timer catch event must have either a time duration or a time date.");
            }
        }
    }
}

