/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter;

import java.util.ArrayList;
import java.util.List;

public class BpmnDiagramCheckResult {
    private final List<BpmnElementCheckResult> results = new ArrayList<BpmnElementCheckResult>();
    private String filename;

    public List<BpmnElementCheckResult> getResults() {
        return this.results;
    }

    public BpmnElementCheckResult getResult(String elementId) {
        return this.getResults().stream().filter(element -> element.getElementId().equals(elementId)).findFirst().orElse(null);
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String toString() {
        return "BpmnDiagramCheckResult{results=" + this.results + ", filename='" + this.filename + '\'' + '}';
    }

    public static class BpmnElementCheckResult {
        private final List<BpmnElementCheckMessage> messages = new ArrayList<BpmnElementCheckMessage>();
        private final List<String> references = new ArrayList<String>();
        private final List<String> referencedBy = new ArrayList<String>();
        private String elementId;
        private String elementName;
        private String elementType;

        public List<BpmnElementCheckMessage> getMessages() {
            return this.messages;
        }

        public String getElementId() {
            return this.elementId;
        }

        public void setElementId(String elementId) {
            this.elementId = elementId;
        }

        public String getElementName() {
            return this.elementName;
        }

        public void setElementName(String elementName) {
            this.elementName = elementName;
        }

        public String getElementType() {
            return this.elementType;
        }

        public void setElementType(String elementType) {
            this.elementType = elementType;
        }

        public List<String> getReferences() {
            return this.references;
        }

        public List<String> getReferencedBy() {
            return this.referencedBy;
        }

        public String toString() {
            return "BpmnElementCheckResult{messages=" + this.messages + ", references=" + this.references + ", referencedBy=" + this.referencedBy + ", elementId='" + this.elementId + '\'' + ", elementName='" + this.elementName + '\'' + ", elementType='" + this.elementType + '\'' + '}';
        }
    }

    public static class BpmnElementCheckMessage {
        private Severity severity;
        private String message;
        private String link;

        public Severity getSeverity() {
            return this.severity;
        }

        public void setSeverity(Severity severity) {
            this.severity = severity;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getLink() {
            return this.link;
        }

        public void setLink(String link) {
            this.link = link;
        }

        public String toString() {
            return "BpmnElementCheckMessage{severity=" + (Object)((Object)this.severity) + ", message='" + this.message + '\'' + ", link='" + this.link + '\'' + '}';
        }
    }

    public static enum Severity {
        WARNING,
        TASK,
        REVIEW,
        INFO;

    }
}

