/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter.visitor.impl;

import java.util.Arrays;
import org.camunda.bpm.model.xml.instance.DomElement;
import org.camunda.community.migration.converter.DomElementVisitorContext;
import org.camunda.community.migration.converter.convertible.SequenceFlowConvertible;
import org.camunda.community.migration.converter.expression.ExpressionTransformationResult;
import org.camunda.community.migration.converter.expression.ExpressionTransformer;
import org.camunda.community.migration.converter.message.Message;
import org.camunda.community.migration.converter.message.MessageFactory;
import org.camunda.community.migration.converter.version.SemanticVersion;
import org.camunda.community.migration.converter.visitor.AbstractBpmnElementVisitor;

public class ConditionExpressionVisitor
extends AbstractBpmnElementVisitor {
    @Override
    protected SemanticVersion availableFrom(DomElementVisitorContext context) {
        return this.isConditionalFlow(context) ? null : SemanticVersion._8_0_0;
    }

    private boolean isConditionalFlow(DomElementVisitorContext context) {
        String sourceRef = context.getElement().getParentElement().getAttribute("http://www.omg.org/spec/BPMN/20100524/MODEL", "sourceRef");
        if (sourceRef == null) {
            return false;
        }
        DomElement source = context.getElement().getDocument().getElementById(sourceRef);
        if (source == null) {
            return false;
        }
        return !this.isGateway(source);
    }

    private boolean isGateway(DomElement element) {
        return element.getNamespaceURI().equals("http://www.omg.org/spec/BPMN/20100524/MODEL") && Arrays.asList("exclusiveGateway", "inclusiveGateway", "complexGateway").contains(element.getLocalName());
    }

    @Override
    public String localName() {
        return "conditionExpression";
    }

    @Override
    protected void visitBpmnElement(DomElementVisitorContext context) {
        String expression = context.getElement().getTextContent();
        ExpressionTransformationResult transformationResult = ExpressionTransformer.transform(expression);
        context.addConversion(SequenceFlowConvertible.class, conversion -> conversion.setConditionExpression(transformationResult.getFeelExpression()));
        if (transformationResult.hasExecution().booleanValue()) {
            context.addMessage(MessageFactory.conditionExpressionExecution(transformationResult));
        } else if (transformationResult.hasMethodInvocation().booleanValue()) {
            context.addMessage(MessageFactory.conditionExpressionMethod(transformationResult));
        } else {
            context.addMessage(MessageFactory.conditionExpression(transformationResult));
        }
    }

    @Override
    protected Message cannotBeConvertedMessage(DomElementVisitorContext context) {
        return MessageFactory.conditionalFlow();
    }
}

