/*
 * Decompiled with CFR 0.152.
 */
package picocli.codegen.aot.graalvm;

import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import picocli.CommandLine;
import picocli.codegen.aot.graalvm.OutputFileMixin;
import picocli.codegen.util.Util;

public class DynamicProxyConfigGenerator {
    public static void main(String ... args) {
        App app = new App();
        int exitCode = new CommandLine(app).execute(args);
        if (app.exit) {
            System.exit(exitCode);
        }
    }

    public static String generateProxyConfig(CommandLine.Model.CommandSpec[] specs, String[] interfaceClasses) {
        Visitor visitor = new Visitor(interfaceClasses);
        for (CommandLine.Model.CommandSpec spec : specs) {
            visitor.visitCommandSpec(spec);
        }
        return visitor.toString();
    }

    static final class Visitor {
        List<String> interfaces = new ArrayList<String>();
        List<String> commandInterfaces = new ArrayList<String>();

        Visitor(String[] interfaceClasses) {
            this.interfaces.addAll(Arrays.asList(interfaceClasses));
        }

        void visitCommandSpec(CommandLine.Model.CommandSpec spec) {
            Object userObject = spec.userObject();
            if (Proxy.isProxyClass(userObject.getClass())) {
                Class<?>[] interfaces = userObject.getClass().getInterfaces();
                String names = "";
                for (Class<?> interf : interfaces) {
                    if (names.length() > 0) {
                        names = names + ",";
                    }
                    names = names + interf.getCanonicalName();
                }
                if (names.length() > 0) {
                    this.commandInterfaces.add(names);
                }
            } else if (spec.userObject() instanceof Element && ((Element)spec.userObject()).getKind() == ElementKind.INTERFACE) {
                this.commandInterfaces.add(((Element)spec.userObject()).asType().toString());
            }
            for (CommandLine.Model.CommandSpec mixin : spec.mixins().values()) {
                this.visitCommandSpec(mixin);
            }
            for (CommandLine sub : spec.subcommands().values()) {
                this.visitCommandSpec(sub.getCommandSpec());
            }
        }

        public String toString() {
            return String.format("[%s%n]%n", this.all());
        }

        private StringBuilder all() {
            return Visitor.json(this.commandInterfaces, this.interfaces);
        }

        private static StringBuilder json(List<String> ... stringLists) {
            StringBuilder result = new StringBuilder(1024);
            for (List<String> list : stringLists) {
                for (String str : list) {
                    if (result.length() > 0) {
                        result.append(",");
                    }
                    String[] names = str.split(",");
                    String formatted = "";
                    for (String name : names) {
                        if (formatted.length() > 0) {
                            formatted = formatted + ", ";
                        }
                        formatted = formatted + '\"' + name + '\"';
                    }
                    result.append(String.format("%n  [%s]", formatted));
                }
            }
            return result;
        }
    }

    @CommandLine.Command(name="gen-proxy-config", showAtFileInUsageHelp=true, sortOptions=false, description={"Generates a JSON file with the interface names to generate dynamic proxy classes for in the native image.", "The generated JSON file can be passed to the `-H:DynamicProxyConfigurationFiles=/path/to/proxy-config.json` option of the `native-image` GraalVM utility.", "See https://www.graalvm.org/latest/reference-manual/native-image/dynamic-features/DynamicProxy/"}, exitCodeListHeading="%nExit Codes (if enabled with `--exit`)%n", exitCodeList={"0:Successful program execution.", "1:A runtime exception occurred while generating man pages.", "2:Usage error: user input for the command was incorrect, e.g., the wrong number of arguments, a bad flag, a bad syntax in a parameter, etc."}, footerHeading="%nExample%n", footer={"  java -cp \"myapp.jar;picocli-4.7.4.jar;picocli-codegen-4.7.4.jar\" picocli.codegen.aot.graalvm.DynamicProxyConfigGenerator my.pkg.MyClass"}, mixinStandardHelpOptions=true, version={"picocli-codegen gen-proxy-config 4.7.4"})
    private static class App
    implements Callable<Integer> {
        @CommandLine.Parameters(arity="0..*", description={"Zero or more `@Command` interfaces or classes with `@Command` interface subcommands to generate a Graal SubstrateVM proxy-config for."})
        Class<?>[] classes = new Class[0];
        @CommandLine.Option(names={"-i", "--interface"}, description={"Other fully qualified interface names to generate dynamic proxy classes for in the native image.This option may be specified multiple times with different interface names. Specify multiple comma-separated interface names for dynamic proxies that implement multiple interfaces."})
        String[] interfaces = new String[0];
        @CommandLine.Option(names={"-c", "--factory"}, description={"Optionally specify the fully qualified class name of the custom factory to use to instantiate the command class. When omitted, the default picocli factory is used."})
        String factoryClass;
        @CommandLine.Mixin
        OutputFileMixin outputFile = new OutputFileMixin();
        @CommandLine.Option(names={"--exit"}, negatable=true, description={"Specify `--exit` if you want the application to call `System.exit` when finished. By default, `System.exit` is not called."})
        boolean exit;

        private App() {
        }

        @Override
        public Integer call() throws Exception {
            List<CommandLine.Model.CommandSpec> specs = Util.getCommandSpecs(this.factoryClass, this.classes);
            String result = DynamicProxyConfigGenerator.generateProxyConfig(specs.toArray(new CommandLine.Model.CommandSpec[0]), this.interfaces);
            this.outputFile.write(result);
            return 0;
        }
    }
}

