/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter.visitor;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.camunda.bpm.model.xml.instance.DomElement;
import org.camunda.community.migration.converter.DomElementVisitorContext;
import org.camunda.community.migration.converter.visitor.AbstractBpmnElementVisitor;

public abstract class AbstractEventDefinitionVisitor
extends AbstractBpmnElementVisitor {
    @Override
    protected final void visitBpmnElement(DomElementVisitorContext context) {
    }

    @Override
    protected String elementNameForMessage(DomElement element) {
        String fullEventName = "";
        if (!this.isInterrupting(element)) {
            fullEventName = fullEventName + "Non-interrupting ";
        }
        if (!this.isNotEventSubProcessStartEvent(element)) {
            fullEventName = fullEventName + "Event Sub Process ";
        }
        fullEventName = fullEventName + this.simpleEventName(element);
        fullEventName = fullEventName + " ";
        fullEventName = fullEventName + StringUtils.capitalize(element.getParentElement().getLocalName().replaceAll("([A-Z])", " $1"));
        return fullEventName;
    }

    protected String simpleEventName(DomElement element) {
        return StringUtils.capitalize(element.getLocalName().split("([A-Z])")[0]);
    }

    protected boolean isNotEventSubProcessStartEvent(DomElement element) {
        if (element.getParentElement().getLocalName().equals("startEvent")) {
            boolean triggeredByEvent = this.parseWithDefault(element.getParentElement().getParentElement().getAttribute("http://www.omg.org/spec/BPMN/20100524/MODEL", "triggeredByEvent"), false);
            return !triggeredByEvent;
        }
        return true;
    }

    protected boolean isInterrupting(DomElement element) {
        boolean isInterrupting = this.parseWithDefault(element.getParentElement().getAttribute("http://www.omg.org/spec/BPMN/20100524/MODEL", "isInterrupting"), true);
        boolean cancelActivity = this.parseWithDefault(element.getParentElement().getAttribute("http://www.omg.org/spec/BPMN/20100524/MODEL", "cancelActivity"), true);
        return isInterrupting && cancelActivity;
    }

    private boolean parseWithDefault(String bool, boolean defaultValue) {
        return Optional.ofNullable(bool).map(Boolean::parseBoolean).orElse(defaultValue);
    }
}

