/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.validation.zeebe;

import io.camunda.zeebe.model.bpmn.instance.EventBasedGateway;
import io.camunda.zeebe.model.bpmn.instance.EventDefinition;
import io.camunda.zeebe.model.bpmn.instance.FlowNode;
import io.camunda.zeebe.model.bpmn.instance.IntermediateCatchEvent;
import io.camunda.zeebe.model.bpmn.instance.MessageEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.SequenceFlow;
import io.camunda.zeebe.model.bpmn.instance.SignalEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.TimerEventDefinition;
import io.camunda.zeebe.model.bpmn.util.ModelUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class EventBasedGatewayValidator
implements ModelElementValidator<EventBasedGateway> {
    private static final List<Class<? extends EventDefinition>> SUPPORTED_EVENTS = Arrays.asList(TimerEventDefinition.class, MessageEventDefinition.class, SignalEventDefinition.class);
    private static final String ERROR_UNSUPPORTED_TARGET_NODE = "Event-based gateway must not have an outgoing sequence flow to other elements than message/timer/signal intermediate catch events.";

    @Override
    public Class<EventBasedGateway> getElementType() {
        return EventBasedGateway.class;
    }

    @Override
    public void validate(EventBasedGateway element, ValidationResultCollector validationResultCollector) {
        boolean isValid;
        Collection<SequenceFlow> outgoingSequenceFlows = element.getOutgoing();
        if (outgoingSequenceFlows.size() < 2) {
            validationResultCollector.addError(0, "Event-based gateway must have at least 2 outgoing sequence flows.");
        }
        if (!(isValid = outgoingSequenceFlows.stream().allMatch(this::isValidOutgoingSequenceFlow))) {
            validationResultCollector.addError(0, ERROR_UNSUPPORTED_TARGET_NODE);
        }
        List messageEventDefinitions = this.getMessageEventDefinitions(outgoingSequenceFlows).collect(Collectors.toList());
        ModelUtil.verifyNoDuplicatedEventDefinition(messageEventDefinitions, error -> validationResultCollector.addError(0, (String)error));
        List signalEventDefinitions = this.getSignalEventDefinitions(outgoingSequenceFlows).collect(Collectors.toList());
        ModelUtil.verifyNoDuplicatedEventDefinition(signalEventDefinitions, error -> validationResultCollector.addError(0, (String)error));
        if (!this.succeedingNodesOnlyHaveEventBasedGatewayAsIncomingFlows(element)) {
            validationResultCollector.addError(0, "Target elements of an event gateway must not have any additional incoming sequence flows other than that from the event gateway.");
        }
    }

    private boolean isValidOutgoingSequenceFlow(SequenceFlow flow) {
        FlowNode targetNode = flow.getTarget();
        if (targetNode instanceof IntermediateCatchEvent) {
            return this.isValidEvent((IntermediateCatchEvent)targetNode);
        }
        return false;
    }

    private boolean isValidEvent(IntermediateCatchEvent event) {
        Collection<EventDefinition> eventDefinitions = event.getEventDefinitions();
        if (eventDefinitions.size() != 1) {
            return false;
        }
        EventDefinition eventDefinition = eventDefinitions.iterator().next();
        return SUPPORTED_EVENTS.stream().anyMatch(e -> e.isAssignableFrom(eventDefinition.getClass()));
    }

    private Stream<MessageEventDefinition> getMessageEventDefinitions(Collection<SequenceFlow> outgoingSequenceFlows) {
        return outgoingSequenceFlows.stream().map(SequenceFlow::getTarget).filter(t -> t instanceof IntermediateCatchEvent).map(IntermediateCatchEvent.class::cast).flatMap(e -> e.getEventDefinitions().stream()).filter(e -> e instanceof MessageEventDefinition).map(MessageEventDefinition.class::cast);
    }

    private Stream<SignalEventDefinition> getSignalEventDefinitions(Collection<SequenceFlow> outgoingSequenceFlows) {
        return outgoingSequenceFlows.stream().map(SequenceFlow::getTarget).filter(t -> t instanceof IntermediateCatchEvent).map(IntermediateCatchEvent.class::cast).flatMap(e -> e.getEventDefinitions().stream()).filter(e -> e instanceof SignalEventDefinition).map(SignalEventDefinition.class::cast);
    }

    private boolean succeedingNodesOnlyHaveEventBasedGatewayAsIncomingFlows(EventBasedGateway element) {
        return element.getSucceedingNodes().stream().flatMap(flowNode -> flowNode.getPreviousNodes().stream()).allMatch(element::equals);
    }
}

