/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.validation.zeebe;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public final class ZeebeElementValidator<T extends ModelElementInstance>
implements ModelElementValidator<T> {
    private final Class<T> elementType;
    private final List<AttributeAssertion<T>> singleAttributeAssertions = new ArrayList<AttributeAssertion<T>>();
    private final List<AttributeAssertion<T>> groupAttributesAssertions = new ArrayList<AttributeAssertion<T>>();

    private ZeebeElementValidator(Class<T> elementType) {
        this.elementType = elementType;
    }

    @Override
    public Class<T> getElementType() {
        return this.elementType;
    }

    @Override
    public void validate(T element, ValidationResultCollector validationResultCollector) {
        long matchCount;
        this.singleAttributeAssertions.forEach(assertions -> {
            String attributeValue = (String)((AttributeAssertion)assertions).attributeSupplier.apply(element);
            if (attributeValue == null || attributeValue.isEmpty()) {
                validationResultCollector.addError(0, String.format("Attribute '%s' must be present and not empty", ((AttributeAssertion)assertions).attributeName));
            }
        });
        if (!this.groupAttributesAssertions.isEmpty() && (matchCount = this.countMatchingGroupAttributesAssertions(element)) != 1L) {
            String attributes = this.getAttributeNames();
            String errorMessage = String.format("Exactly one of the attributes '%s' must be present and not blank", attributes);
            validationResultCollector.addError(0, errorMessage);
        }
    }

    public ZeebeElementValidator<T> hasNonEmptyAttribute(Function<T, String> attributeSupplier, String attributeName) {
        this.singleAttributeAssertions.add(new AttributeAssertion(attributeSupplier, attributeName));
        return this;
    }

    public ZeebeElementValidator<T> hasOnlyOneAttributeInGroup(Map<String, Function<T, String>> nameToAttributeSupplier) {
        nameToAttributeSupplier.forEach((attributeName, attributeSupplier) -> this.groupAttributesAssertions.add(new AttributeAssertion((Function)attributeSupplier, (String)attributeName)));
        return this;
    }

    public static <T extends ModelElementInstance> ZeebeElementValidator<T> verifyThat(Class<T> elementType) {
        return new ZeebeElementValidator<T>(elementType);
    }

    private long countMatchingGroupAttributesAssertions(T element) {
        return this.groupAttributesAssertions.stream().filter(assertion -> {
            String attributeValue = (String)((AttributeAssertion)assertion).attributeSupplier.apply(element);
            return attributeValue != null && !attributeValue.trim().isEmpty();
        }).count();
    }

    private String getAttributeNames() {
        return this.groupAttributesAssertions.stream().map(assertion -> ((AttributeAssertion)assertion).attributeName).collect(Collectors.joining(", "));
    }

    private static final class AttributeAssertion<T extends ModelElementInstance> {
        private final Function<T, String> attributeSupplier;
        private final String attributeName;

        private AttributeAssertion(Function<T, String> attributeSupplier, String attributeName) {
            this.attributeSupplier = attributeSupplier;
            this.attributeName = attributeName;
        }
    }
}

