/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter.conversion;

import java.util.Optional;
import org.camunda.bpm.model.xml.instance.DomElement;
import org.camunda.community.migration.converter.conversion.AbstractTypedConversion;
import org.camunda.community.migration.converter.convertible.AbstractCatchEventConvertible;

public class AbstractCatchEventConversion
extends AbstractTypedConversion<AbstractCatchEventConvertible> {
    @Override
    protected Class<AbstractCatchEventConvertible> type() {
        return AbstractCatchEventConvertible.class;
    }

    @Override
    protected void convertTyped(DomElement element, AbstractCatchEventConvertible convertible) {
        this.getTimerEventDefinition(element).ifPresent(timerEventDefinition -> {
            this.getTimeDuration((DomElement)timerEventDefinition).ifPresent(timeDuration -> this.applyExpression((DomElement)timeDuration, convertible.getTimeDurationExpression()));
            this.getTimeDate((DomElement)timerEventDefinition).ifPresent(timeDate -> this.applyExpression((DomElement)timeDate, convertible.getTimeDateExpression()));
            this.getTimeCycle((DomElement)timerEventDefinition).ifPresent(timeCycle -> this.applyExpression((DomElement)timeCycle, convertible.getTimeCycleExpression()));
        });
    }

    private void applyExpression(DomElement container, String expression) {
        if (expression != null) {
            container.setTextContent(expression);
        }
    }

    private Optional<DomElement> getTimerEventDefinition(DomElement element) {
        return this.getChildElement(element, "http://www.omg.org/spec/BPMN/20100524/MODEL", "timerEventDefinition");
    }

    private Optional<DomElement> getTimeDuration(DomElement timerEventDefinition) {
        return this.getChildElement(timerEventDefinition, "http://www.omg.org/spec/BPMN/20100524/MODEL", "timeDuration");
    }

    private Optional<DomElement> getTimeDate(DomElement timerEventDefinition) {
        return this.getChildElement(timerEventDefinition, "http://www.omg.org/spec/BPMN/20100524/MODEL", "timeDate");
    }

    private Optional<DomElement> getTimeCycle(DomElement timerEventDefinition) {
        return this.getChildElement(timerEventDefinition, "http://www.omg.org/spec/BPMN/20100524/MODEL", "timeCycle");
    }

    private Optional<DomElement> getChildElement(DomElement element, String namespaceUri, String localName) {
        return element.getChildElementsByNameNs(namespaceUri, localName).stream().findFirst();
    }
}

