/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotatedMethod;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotationPredicates;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.http.HttpStatusCode;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ResponseStatus;

public class HandlerMethod
extends AnnotatedMethod {
    protected static final Log logger = LogFactory.getLog(HandlerMethod.class);
    private final Object bean;
    @Nullable
    private final BeanFactory beanFactory;
    @Nullable
    private final MessageSource messageSource;
    private final Class<?> beanType;
    private final boolean validateArguments;
    private final boolean validateReturnValue;
    @Nullable
    private HttpStatusCode responseStatus;
    @Nullable
    private String responseStatusReason;
    @Nullable
    private HandlerMethod resolvedFromHandlerMethod;
    private final String description;

    public HandlerMethod(Object bean, Method method) {
        this(bean, method, null);
    }

    protected HandlerMethod(Object bean, Method method, @Nullable MessageSource messageSource) {
        super(method);
        this.bean = bean;
        this.beanFactory = null;
        this.messageSource = messageSource;
        this.beanType = ClassUtils.getUserClass(bean);
        this.validateArguments = MethodValidationInitializer.checkArguments(this.beanType, this.getMethodParameters());
        this.validateReturnValue = MethodValidationInitializer.checkReturnValue(this.beanType, this.getBridgedMethod());
        this.evaluateResponseStatus();
        this.description = HandlerMethod.initDescription(this.beanType, method);
    }

    public HandlerMethod(Object bean, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        super(bean.getClass().getMethod(methodName, parameterTypes));
        this.bean = bean;
        this.beanFactory = null;
        this.messageSource = null;
        this.beanType = ClassUtils.getUserClass(bean);
        this.validateArguments = MethodValidationInitializer.checkArguments(this.beanType, this.getMethodParameters());
        this.validateReturnValue = MethodValidationInitializer.checkReturnValue(this.beanType, this.getBridgedMethod());
        this.evaluateResponseStatus();
        this.description = HandlerMethod.initDescription(this.beanType, this.getMethod());
    }

    public HandlerMethod(String beanName, BeanFactory beanFactory, Method method) {
        this(beanName, beanFactory, null, method);
    }

    public HandlerMethod(String beanName, BeanFactory beanFactory, @Nullable MessageSource messageSource, Method method) {
        super(method);
        Assert.hasText(beanName, "Bean name is required");
        Assert.notNull((Object)beanFactory, "BeanFactory is required");
        this.bean = beanName;
        this.beanFactory = beanFactory;
        this.messageSource = messageSource;
        Class<?> beanType = beanFactory.getType(beanName);
        if (beanType == null) {
            throw new IllegalStateException("Cannot resolve bean type for bean with name '" + beanName + "'");
        }
        this.beanType = ClassUtils.getUserClass(beanType);
        this.validateArguments = MethodValidationInitializer.checkArguments(this.beanType, this.getMethodParameters());
        this.validateReturnValue = MethodValidationInitializer.checkReturnValue(this.beanType, this.getBridgedMethod());
        this.evaluateResponseStatus();
        this.description = HandlerMethod.initDescription(this.beanType, method);
    }

    protected HandlerMethod(HandlerMethod handlerMethod) {
        super(handlerMethod);
        this.bean = handlerMethod.bean;
        this.beanFactory = handlerMethod.beanFactory;
        this.messageSource = handlerMethod.messageSource;
        this.beanType = handlerMethod.beanType;
        this.validateArguments = handlerMethod.validateArguments;
        this.validateReturnValue = handlerMethod.validateReturnValue;
        this.responseStatus = handlerMethod.responseStatus;
        this.responseStatusReason = handlerMethod.responseStatusReason;
        this.description = handlerMethod.description;
        this.resolvedFromHandlerMethod = handlerMethod.resolvedFromHandlerMethod;
    }

    private HandlerMethod(HandlerMethod handlerMethod, Object handler) {
        super(handlerMethod);
        Assert.notNull(handler, "Handler object is required");
        this.bean = handler;
        this.beanFactory = handlerMethod.beanFactory;
        this.messageSource = handlerMethod.messageSource;
        this.beanType = handlerMethod.beanType;
        this.validateArguments = handlerMethod.validateArguments;
        this.validateReturnValue = handlerMethod.validateReturnValue;
        this.responseStatus = handlerMethod.responseStatus;
        this.responseStatusReason = handlerMethod.responseStatusReason;
        this.resolvedFromHandlerMethod = handlerMethod;
        this.description = handlerMethod.description;
    }

    private void evaluateResponseStatus() {
        ResponseStatus annotation = this.getMethodAnnotation(ResponseStatus.class);
        if (annotation == null) {
            annotation = AnnotatedElementUtils.findMergedAnnotation(this.getBeanType(), ResponseStatus.class);
        }
        if (annotation != null) {
            String reason = annotation.reason();
            String resolvedReason = StringUtils.hasText(reason) && this.messageSource != null ? this.messageSource.getMessage(reason, null, reason, LocaleContextHolder.getLocale()) : reason;
            this.responseStatus = annotation.code();
            this.responseStatusReason = resolvedReason;
            if (StringUtils.hasText(this.responseStatusReason) && this.getMethod().getReturnType() != Void.TYPE) {
                logger.warn("Return value of [" + this.getMethod() + "] will be ignored since @ResponseStatus 'reason' attribute is set.");
            }
        }
    }

    private static String initDescription(Class<?> beanType, Method method) {
        StringJoiner joiner = new StringJoiner(", ", "(", ")");
        for (Class<?> paramType : method.getParameterTypes()) {
            joiner.add(paramType.getSimpleName());
        }
        return beanType.getName() + "#" + method.getName() + joiner;
    }

    public Object getBean() {
        return this.bean;
    }

    public Class<?> getBeanType() {
        return this.beanType;
    }

    @Override
    protected Class<?> getContainingClass() {
        return this.beanType;
    }

    public boolean shouldValidateArguments() {
        return this.validateArguments;
    }

    public boolean shouldValidateReturnValue() {
        return this.validateReturnValue;
    }

    @Nullable
    protected HttpStatusCode getResponseStatus() {
        return this.responseStatus;
    }

    @Nullable
    protected String getResponseStatusReason() {
        return this.responseStatusReason;
    }

    @Nullable
    public HandlerMethod getResolvedFromHandlerMethod() {
        return this.resolvedFromHandlerMethod;
    }

    public HandlerMethod createWithResolvedBean() {
        Object handler = this.bean;
        Object object = this.bean;
        if (object instanceof String) {
            String beanName = (String)object;
            Assert.state(this.beanFactory != null, "Cannot resolve bean name without BeanFactory");
            handler = this.beanFactory.getBean(beanName);
        }
        return new HandlerMethod(this, handler);
    }

    public String getShortLogMessage() {
        return this.getBeanType().getName() + "#" + this.getMethod().getName() + "[" + this.getMethod().getParameterCount() + " args]";
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return this == other || super.equals(other) && this.bean.equals(((HandlerMethod)other).bean);
    }

    @Override
    public int hashCode() {
        return this.bean.hashCode() * 31 + super.hashCode();
    }

    @Override
    public String toString() {
        return this.description;
    }

    protected void assertTargetBean(Method method, Object targetBean, Object[] args) {
        Class<?> targetBeanClass;
        Class<?> methodDeclaringClass = method.getDeclaringClass();
        if (!methodDeclaringClass.isAssignableFrom(targetBeanClass = targetBean.getClass())) {
            String text = "The mapped handler method class '" + methodDeclaringClass.getName() + "' is not an instance of the actual controller bean class '" + targetBeanClass.getName() + "'. If the controller requires proxying (e.g. due to @Transactional), please use class-based proxying.";
            throw new IllegalStateException(this.formatInvokeError(text, args));
        }
    }

    protected String formatInvokeError(String text, Object[] args) {
        String formattedArgs = IntStream.range(0, args.length).mapToObj(i -> args[i] != null ? "[" + i + "] [type=" + args[i].getClass().getName() + "] [value=" + args[i] + "]" : "[" + i + "] [null]").collect(Collectors.joining(",\n", " ", " "));
        return text + "\nController [" + this.getBeanType().getName() + "]\nMethod [" + this.getBridgedMethod().toGenericString() + "] with argument values:\n" + formattedArgs;
    }

    private static class MethodValidationInitializer {
        private static final Predicate<MergedAnnotation<? extends Annotation>> CONSTRAINT_PREDICATE = MergedAnnotationPredicates.typeIn("jakarta.validation.Constraint");
        private static final Predicate<MergedAnnotation<? extends Annotation>> VALID_PREDICATE = MergedAnnotationPredicates.typeIn("jakarta.validation.Valid");

        private MethodValidationInitializer() {
        }

        public static boolean checkArguments(Class<?> beanType, MethodParameter[] parameters) {
            if (AnnotationUtils.findAnnotation(beanType, Validated.class) == null) {
                for (MethodParameter parameter : parameters) {
                    MergedAnnotations merged = MergedAnnotations.from(parameter.getParameterAnnotations());
                    if (merged.stream().anyMatch(CONSTRAINT_PREDICATE)) {
                        return true;
                    }
                    Class<?> type = parameter.getParameterType();
                    if (!merged.stream().anyMatch(VALID_PREDICATE) || !List.class.isAssignableFrom(type)) continue;
                    return true;
                }
            }
            return false;
        }

        public static boolean checkReturnValue(Class<?> beanType, Method method) {
            if (AnnotationUtils.findAnnotation(beanType, Validated.class) == null) {
                MergedAnnotations merged = MergedAnnotations.from(method, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY);
                return merged.stream().anyMatch(CONSTRAINT_PREDICATE.or(VALID_PREDICATE));
            }
            return false;
        }
    }
}

