/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter.conversion;

import org.camunda.bpm.model.xml.instance.DomDocument;
import org.camunda.bpm.model.xml.instance.DomElement;
import org.camunda.community.migration.converter.BpmnElementFactory;
import org.camunda.community.migration.converter.conversion.AbstractTypedConversion;
import org.camunda.community.migration.converter.convertible.AbstractActivityConvertible;

public class ActivityConversion
extends AbstractTypedConversion<AbstractActivityConvertible> {
    @Override
    protected Class<AbstractActivityConvertible> type() {
        return AbstractActivityConvertible.class;
    }

    @Override
    public final void convertTyped(DomElement element, AbstractActivityConvertible convertible) {
        if (convertible.wasLoopCharacteristicsInitialized()) {
            this.createMultiInstance(element, convertible.getBpmnMultiInstanceLoopCharacteristics());
        }
    }

    private void createMultiInstance(DomElement element, AbstractActivityConvertible.BpmnMultiInstanceLoopCharacteristics bpmnMultiInstanceLoopCharacteristics) {
        DomElement multiInstanceLoopCharacteristics = BpmnElementFactory.getMultiInstanceLoopCharacteristics(element);
        if (bpmnMultiInstanceLoopCharacteristics.isSequential()) {
            multiInstanceLoopCharacteristics.setAttribute("isSequential", Boolean.toString(true));
        }
        DomElement extensionElements = BpmnElementFactory.getExtensionElements(multiInstanceLoopCharacteristics);
        extensionElements.appendChild(this.createLoopCharacteristics(element.getDocument(), bpmnMultiInstanceLoopCharacteristics));
        if (bpmnMultiInstanceLoopCharacteristics.getCompletionCondition() != null) {
            this.createCompletionCondition(multiInstanceLoopCharacteristics, bpmnMultiInstanceLoopCharacteristics);
        }
    }

    private DomElement createLoopCharacteristics(DomDocument document, AbstractActivityConvertible.BpmnMultiInstanceLoopCharacteristics bpmnMultiInstanceLoopCharacteristics) {
        DomElement loopCharacteristics = document.createElement("http://camunda.org/schema/zeebe/1.0", "loopCharacteristics");
        AbstractActivityConvertible.ZeebeLoopCharacteristics zbLoopCharacteristics = bpmnMultiInstanceLoopCharacteristics.getZeebeLoopCharacteristics();
        if (zbLoopCharacteristics.getInputCollection() != null) {
            loopCharacteristics.setAttribute("inputCollection", zbLoopCharacteristics.getInputCollection());
        }
        if (zbLoopCharacteristics.getInputElement() != null) {
            loopCharacteristics.setAttribute("inputElement", zbLoopCharacteristics.getInputElement());
        }
        if (zbLoopCharacteristics.getOutputCollection() != null) {
            loopCharacteristics.setAttribute("outputCollection", zbLoopCharacteristics.getOutputCollection());
        }
        if (zbLoopCharacteristics.getOutputElement() != null) {
            loopCharacteristics.setAttribute("outputElement", zbLoopCharacteristics.getOutputElement());
        }
        return loopCharacteristics;
    }

    private void createCompletionCondition(DomElement element, AbstractActivityConvertible.BpmnMultiInstanceLoopCharacteristics bpmnMultiInstanceLoopCharacteristics) {
        DomElement completionCondition = BpmnElementFactory.getCompletionCondition(element);
        completionCondition.setTextContent(bpmnMultiInstanceLoopCharacteristics.getCompletionCondition());
    }
}

