/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter.visitor.impl.eventReference;

import org.camunda.community.migration.converter.DomElementVisitorContext;
import org.camunda.community.migration.converter.convertible.Convertible;
import org.camunda.community.migration.converter.convertible.ErrorConvertible;
import org.camunda.community.migration.converter.expression.ExpressionTransformationResult;
import org.camunda.community.migration.converter.expression.ExpressionTransformer;
import org.camunda.community.migration.converter.message.MessageFactory;
import org.camunda.community.migration.converter.version.SemanticVersion;
import org.camunda.community.migration.converter.visitor.AbstractEventReferenceVisitor;

public class ErrorVisitor
extends AbstractEventReferenceVisitor {
    @Override
    public String localName() {
        return "error";
    }

    @Override
    protected Convertible createConvertible(DomElementVisitorContext context) {
        return new ErrorConvertible();
    }

    @Override
    protected SemanticVersion availableFrom(DomElementVisitorContext context) {
        return SemanticVersion._8_0;
    }

    @Override
    protected void postCreationVisitor(DomElementVisitorContext context) {
        String errorCode = context.getElement().getAttribute("http://www.omg.org/spec/BPMN/20100524/MODEL", "errorCode");
        if (errorCode == null) {
            return;
        }
        ExpressionTransformationResult expressionTransformationResult = ExpressionTransformer.transform(errorCode);
        if (expressionTransformationResult.getFeelExpression().startsWith("=")) {
            context.addMessage(MessageFactory.errorCodeNoExpression());
        }
        context.addConversion(ErrorConvertible.class, c -> c.setErrorCode(expressionTransformationResult.getFeelExpression()));
    }
}

