/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.camunda.community.migration.converter.AbstractFactory;
import org.camunda.community.migration.converter.ConverterProperties;
import org.camunda.community.migration.converter.DefaultConverterProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConverterPropertiesFactory
extends AbstractFactory<ConverterProperties> {
    public static final String DELIMITER = ".";
    private static final Logger LOG = LoggerFactory.getLogger(ConverterPropertiesFactory.class);
    private static final ConverterPropertiesFactory INSTANCE = new ConverterPropertiesFactory();
    private static final Properties PROPERTIES = new Properties();

    public static ConverterPropertiesFactory getInstance() {
        return INSTANCE;
    }

    @Override
    protected ConverterProperties createInstance() {
        return this.merge(new DefaultConverterProperties());
    }

    public ConverterProperties merge(DefaultConverterProperties properties) {
        this.readDefaultValues(properties);
        return properties;
    }

    private void readDefaultValues(DefaultConverterProperties properties) {
        this.readZeebeJobType("default", properties::getDefaultJobType, properties::setDefaultJobType);
        this.readZeebeJobType("script", properties::getScriptJobType, properties::setScriptJobType);
        this.readZeebeHeader("script", properties::getScriptHeader, properties::setScriptHeader);
        this.readZeebeHeader("result-variable", properties::getResultVariableHeader, properties::setResultVariableHeader);
        this.readZeebeHeader("resource", properties::getResourceHeader, properties::setResourceHeader);
        this.readZeebeHeader("script-format", properties::getScriptFormatHeader, properties::setScriptFormatHeader);
        this.readZeebePlatformInfo("version", properties::getPlatformVersion, properties::setPlatformVersion);
        this.readFlag("default-job-type-enabled", properties::getDefaultJobTypeEnabled, properties::setDefaultJobTypeEnabled);
        this.readFlag("append-documentation", properties::getAppendDocumentation, properties::setAppendDocumentation);
    }

    private void readZeebeJobType(String jobType, Supplier<String> getter, Consumer<String> setter) {
        String key = String.join((CharSequence)DELIMITER, "zeebe-job-type", jobType);
        this.readDefaultValue(key, getter, setter, s -> s);
    }

    private void readZeebePlatformInfo(String info, Supplier<String> getter, Consumer<String> setter) {
        String key = String.join((CharSequence)DELIMITER, "zeebe-platform", info);
        this.readDefaultValue(key, getter, setter, s -> s);
    }

    private void readZeebeHeader(String header, Supplier<String> getter, Consumer<String> setter) {
        String key = String.join((CharSequence)DELIMITER, "zeebe-header", header);
        this.readDefaultValue(key, getter, setter, s -> s);
    }

    private void readFlag(String header, Supplier<Boolean> getter, Consumer<Boolean> setter) {
        String key = String.join((CharSequence)DELIMITER, "flag", header);
        this.readDefaultValue(key, getter, setter, Boolean::parseBoolean);
    }

    private <T> void readDefaultValue(String key, Supplier<T> getter, Consumer<T> setter, Function<String, T> mapper) {
        T currentValue = getter.get();
        if (currentValue != null) {
            LOG.debug("Converter property {} already set", (Object)key);
            return;
        }
        LOG.debug("Reading converter property {}", (Object)key);
        T value = mapper.apply(PROPERTIES.getProperty(key));
        if (value == null) {
            throw new RuntimeException("No property found for key '" + key + "' while reading default values");
        }
        setter.accept(value);
    }

    static {
        try (InputStream in = ConverterPropertiesFactory.class.getClassLoader().getResourceAsStream("converter-properties.properties");){
            PROPERTIES.load(in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

