/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.aot;

import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

@FunctionalInterface
public interface AutowiredArguments {
    @Nullable
    default public <T> T get(int index, Class<T> requiredType) {
        Object value = this.getObject(index);
        if (!ClassUtils.isAssignableValue(requiredType, value)) {
            throw new IllegalArgumentException("Argument type mismatch: expected '" + ClassUtils.getQualifiedName(requiredType) + "' for value [" + value + "]");
        }
        return (T)value;
    }

    @Nullable
    default public <T> T get(int index) {
        return (T)this.getObject(index);
    }

    @Nullable
    default public Object getObject(int index) {
        return this.toArray()[index];
    }

    public Object[] toArray();

    public static AutowiredArguments of(Object[] arguments) {
        Assert.notNull((Object)arguments, "'arguments' must not be null");
        return () -> arguments;
    }
}

