/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.model.bpmn.impl.instance;

import java.util.Collection;
import java.util.List;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.ProcessType;
import org.camunda.bpm.model.bpmn.builder.ProcessBuilder;
import org.camunda.bpm.model.bpmn.impl.instance.CallableElementImpl;
import org.camunda.bpm.model.bpmn.impl.instance.Supports;
import org.camunda.bpm.model.bpmn.instance.Artifact;
import org.camunda.bpm.model.bpmn.instance.Auditing;
import org.camunda.bpm.model.bpmn.instance.CallableElement;
import org.camunda.bpm.model.bpmn.instance.CorrelationSubscription;
import org.camunda.bpm.model.bpmn.instance.FlowElement;
import org.camunda.bpm.model.bpmn.instance.LaneSet;
import org.camunda.bpm.model.bpmn.instance.Monitoring;
import org.camunda.bpm.model.bpmn.instance.Process;
import org.camunda.bpm.model.bpmn.instance.Property;
import org.camunda.bpm.model.bpmn.instance.ResourceRole;
import org.camunda.bpm.model.xml.ModelBuilder;
import org.camunda.bpm.model.xml.impl.instance.ModelTypeInstanceContext;
import org.camunda.bpm.model.xml.impl.util.StringUtil;
import org.camunda.bpm.model.xml.type.ModelElementTypeBuilder;
import org.camunda.bpm.model.xml.type.attribute.Attribute;
import org.camunda.bpm.model.xml.type.child.ChildElement;
import org.camunda.bpm.model.xml.type.child.ChildElementCollection;
import org.camunda.bpm.model.xml.type.child.SequenceBuilder;
import org.camunda.bpm.model.xml.type.reference.ElementReferenceCollection;

public class ProcessImpl
extends CallableElementImpl
implements Process {
    protected static Attribute<ProcessType> processTypeAttribute;
    protected static Attribute<Boolean> isClosedAttribute;
    protected static Attribute<Boolean> isExecutableAttribute;
    protected static ChildElement<Auditing> auditingChild;
    protected static ChildElement<Monitoring> monitoringChild;
    protected static ChildElementCollection<Property> propertyCollection;
    protected static ChildElementCollection<LaneSet> laneSetCollection;
    protected static ChildElementCollection<FlowElement> flowElementCollection;
    protected static ChildElementCollection<Artifact> artifactCollection;
    protected static ChildElementCollection<ResourceRole> resourceRoleCollection;
    protected static ChildElementCollection<CorrelationSubscription> correlationSubscriptionCollection;
    protected static ElementReferenceCollection<Process, Supports> supportsCollection;
    protected static Attribute<String> camundaCandidateStarterGroupsAttribute;
    protected static Attribute<String> camundaCandidateStarterUsersAttribute;
    protected static Attribute<String> camundaJobPriorityAttribute;
    protected static Attribute<String> camundaTaskPriorityAttribute;
    protected static Attribute<String> camundaHistoryTimeToLiveAttribute;
    protected static Attribute<Boolean> camundaIsStartableInTasklistAttribute;
    protected static Attribute<String> camundaVersionTagAttribute;

    public static void registerType(ModelBuilder modelBuilder) {
        ModelElementTypeBuilder typeBuilder = modelBuilder.defineType(Process.class, "process").namespaceUri("http://www.omg.org/spec/BPMN/20100524/MODEL").extendsType(CallableElement.class).instanceProvider(new ModelElementTypeBuilder.ModelTypeInstanceProvider<Process>(){

            @Override
            public Process newInstance(ModelTypeInstanceContext instanceContext) {
                return new ProcessImpl(instanceContext);
            }
        });
        processTypeAttribute = typeBuilder.enumAttribute("processType", ProcessType.class).defaultValue(ProcessType.None).build();
        isClosedAttribute = typeBuilder.booleanAttribute("isClosed").defaultValue(false).build();
        isExecutableAttribute = typeBuilder.booleanAttribute("isExecutable").build();
        SequenceBuilder sequenceBuilder = typeBuilder.sequence();
        auditingChild = sequenceBuilder.element(Auditing.class).build();
        monitoringChild = sequenceBuilder.element(Monitoring.class).build();
        propertyCollection = sequenceBuilder.elementCollection(Property.class).build();
        laneSetCollection = sequenceBuilder.elementCollection(LaneSet.class).build();
        flowElementCollection = sequenceBuilder.elementCollection(FlowElement.class).build();
        artifactCollection = sequenceBuilder.elementCollection(Artifact.class).build();
        resourceRoleCollection = sequenceBuilder.elementCollection(ResourceRole.class).build();
        correlationSubscriptionCollection = sequenceBuilder.elementCollection(CorrelationSubscription.class).build();
        supportsCollection = sequenceBuilder.elementCollection(Supports.class).qNameElementReferenceCollection(Process.class).build();
        camundaCandidateStarterGroupsAttribute = typeBuilder.stringAttribute("candidateStarterGroups").namespace("http://camunda.org/schema/1.0/bpmn").build();
        camundaCandidateStarterUsersAttribute = typeBuilder.stringAttribute("candidateStarterUsers").namespace("http://camunda.org/schema/1.0/bpmn").build();
        camundaJobPriorityAttribute = typeBuilder.stringAttribute("jobPriority").namespace("http://camunda.org/schema/1.0/bpmn").build();
        camundaTaskPriorityAttribute = typeBuilder.stringAttribute("taskPriority").namespace("http://camunda.org/schema/1.0/bpmn").build();
        camundaHistoryTimeToLiveAttribute = typeBuilder.stringAttribute("historyTimeToLive").namespace("http://camunda.org/schema/1.0/bpmn").build();
        camundaIsStartableInTasklistAttribute = typeBuilder.booleanAttribute("isStartableInTasklist").defaultValue(true).namespace("http://camunda.org/schema/1.0/bpmn").build();
        camundaVersionTagAttribute = typeBuilder.stringAttribute("versionTag").namespace("http://camunda.org/schema/1.0/bpmn").build();
        typeBuilder.build();
    }

    public ProcessImpl(ModelTypeInstanceContext context) {
        super(context);
    }

    @Override
    public ProcessBuilder builder() {
        return new ProcessBuilder((BpmnModelInstance)((Object)this.modelInstance), this);
    }

    @Override
    public ProcessType getProcessType() {
        return processTypeAttribute.getValue(this);
    }

    @Override
    public void setProcessType(ProcessType processType) {
        processTypeAttribute.setValue(this, processType);
    }

    @Override
    public boolean isClosed() {
        return isClosedAttribute.getValue(this);
    }

    @Override
    public void setClosed(boolean closed) {
        isClosedAttribute.setValue(this, closed);
    }

    @Override
    public boolean isExecutable() {
        return isExecutableAttribute.getValue(this);
    }

    @Override
    public void setExecutable(boolean executable) {
        isExecutableAttribute.setValue(this, executable);
    }

    @Override
    public Auditing getAuditing() {
        return auditingChild.getChild(this);
    }

    @Override
    public void setAuditing(Auditing auditing) {
        auditingChild.setChild(this, auditing);
    }

    @Override
    public Monitoring getMonitoring() {
        return monitoringChild.getChild(this);
    }

    @Override
    public void setMonitoring(Monitoring monitoring) {
        monitoringChild.setChild(this, monitoring);
    }

    @Override
    public Collection<Property> getProperties() {
        return propertyCollection.get(this);
    }

    @Override
    public Collection<LaneSet> getLaneSets() {
        return laneSetCollection.get(this);
    }

    @Override
    public Collection<FlowElement> getFlowElements() {
        return flowElementCollection.get(this);
    }

    @Override
    public Collection<Artifact> getArtifacts() {
        return artifactCollection.get(this);
    }

    @Override
    public Collection<CorrelationSubscription> getCorrelationSubscriptions() {
        return correlationSubscriptionCollection.get(this);
    }

    @Override
    public Collection<ResourceRole> getResourceRoles() {
        return resourceRoleCollection.get(this);
    }

    @Override
    public Collection<Process> getSupports() {
        return supportsCollection.getReferenceTargetElements(this);
    }

    @Override
    public String getCamundaCandidateStarterGroups() {
        return camundaCandidateStarterGroupsAttribute.getValue(this);
    }

    @Override
    public void setCamundaCandidateStarterGroups(String camundaCandidateStarterGroups) {
        camundaCandidateStarterGroupsAttribute.setValue(this, camundaCandidateStarterGroups);
    }

    @Override
    public List<String> getCamundaCandidateStarterGroupsList() {
        String groupsString = camundaCandidateStarterGroupsAttribute.getValue(this);
        return StringUtil.splitCommaSeparatedList(groupsString);
    }

    @Override
    public void setCamundaCandidateStarterGroupsList(List<String> camundaCandidateStarterGroupsList) {
        String candidateStarterGroups = StringUtil.joinCommaSeparatedList(camundaCandidateStarterGroupsList);
        camundaCandidateStarterGroupsAttribute.setValue(this, candidateStarterGroups);
    }

    @Override
    public String getCamundaCandidateStarterUsers() {
        return camundaCandidateStarterUsersAttribute.getValue(this);
    }

    @Override
    public void setCamundaCandidateStarterUsers(String camundaCandidateStarterUsers) {
        camundaCandidateStarterUsersAttribute.setValue(this, camundaCandidateStarterUsers);
    }

    @Override
    public List<String> getCamundaCandidateStarterUsersList() {
        String candidateStarterUsers = camundaCandidateStarterUsersAttribute.getValue(this);
        return StringUtil.splitCommaSeparatedList(candidateStarterUsers);
    }

    @Override
    public void setCamundaCandidateStarterUsersList(List<String> camundaCandidateStarterUsersList) {
        String candidateStarterUsers = StringUtil.joinCommaSeparatedList(camundaCandidateStarterUsersList);
        camundaCandidateStarterUsersAttribute.setValue(this, candidateStarterUsers);
    }

    @Override
    public String getCamundaJobPriority() {
        return camundaJobPriorityAttribute.getValue(this);
    }

    @Override
    public void setCamundaJobPriority(String jobPriority) {
        camundaJobPriorityAttribute.setValue(this, jobPriority);
    }

    @Override
    public String getCamundaTaskPriority() {
        return camundaTaskPriorityAttribute.getValue(this);
    }

    @Override
    public void setCamundaTaskPriority(String taskPriority) {
        camundaTaskPriorityAttribute.setValue(this, taskPriority);
    }

    @Override
    public Integer getCamundaHistoryTimeToLive() {
        String ttl = this.getCamundaHistoryTimeToLiveString();
        if (ttl != null) {
            return Integer.parseInt(ttl);
        }
        return null;
    }

    @Override
    public void setCamundaHistoryTimeToLive(Integer historyTimeToLive) {
        this.setCamundaHistoryTimeToLiveString(String.valueOf(historyTimeToLive));
    }

    @Override
    public String getCamundaHistoryTimeToLiveString() {
        return camundaHistoryTimeToLiveAttribute.getValue(this);
    }

    @Override
    public void setCamundaHistoryTimeToLiveString(String historyTimeToLive) {
        camundaHistoryTimeToLiveAttribute.setValue(this, historyTimeToLive);
    }

    @Override
    public Boolean isCamundaStartableInTasklist() {
        return camundaIsStartableInTasklistAttribute.getValue(this);
    }

    @Override
    public void setCamundaIsStartableInTasklist(Boolean isStartableInTasklist) {
        camundaIsStartableInTasklistAttribute.setValue(this, isStartableInTasklist);
    }

    @Override
    public String getCamundaVersionTag() {
        return camundaVersionTagAttribute.getValue(this);
    }

    @Override
    public void setCamundaVersionTag(String versionTag) {
        camundaVersionTagAttribute.setValue(this, versionTag);
    }
}

