/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter.cli;

import java.util.Collections;
import java.util.List;
import org.camunda.community.migration.converter.cli.ProcessDefinitionDiagramDto;
import org.camunda.community.migration.converter.cli.ProcessDefinitionDto;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.lang.Nullable;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.DefaultUriBuilderFactory;

public class ProcessEngineClient {
    private static final String LATEST_PROCESS_DEFINITIONS = "/process-definition?latestVersion=true";
    private static final String PROCESS_DEFINITION_XML = "/process-definition/{id}/xml";
    private final RestTemplate restTemplate = new RestTemplate();

    private ProcessEngineClient(String url) {
        this.restTemplate.setUriTemplateHandler(new DefaultUriBuilderFactory(url));
    }

    private ProcessEngineClient(String url, String username, String password) {
        this(url);
        this.restTemplate.getInterceptors().add(new BasicAuthenticationInterceptor(username, password));
    }

    public static ProcessEngineClient withEngine(String url, @Nullable String username, @Nullable String password) {
        if (username == null || password == null) {
            return new ProcessEngineClient(url);
        }
        return new ProcessEngineClient(url, username, password);
    }

    public List<ProcessDefinitionDto> getAllLatestProcessDefinitions() {
        return (List)this.restTemplate.exchange(LATEST_PROCESS_DEFINITIONS, HttpMethod.GET, null, new ParameterizedTypeReference<List<ProcessDefinitionDto>>(){}, new Object[0]).getBody();
    }

    public ProcessDefinitionDiagramDto getBpmnXml(String processDefinitionId) {
        return this.restTemplate.getForObject(PROCESS_DEFINITION_XML, ProcessDefinitionDiagramDto.class, Collections.singletonMap("id", processDefinitionId));
    }
}

