/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialFormat;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.modules.SerializersModule;
import org.springframework.core.ResolvableType;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.lang.Nullable;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.MimeType;

public abstract class KotlinSerializationSupport<T extends SerialFormat> {
    private final Map<Type, KSerializer<Object>> serializerCache = new ConcurrentReferenceHashMap<Type, KSerializer<Object>>();
    private final T format;
    private final List<MimeType> supportedMimeTypes;

    protected KotlinSerializationSupport(T format, MimeType ... supportedMimeTypes) {
        this.format = format;
        this.supportedMimeTypes = Arrays.asList(supportedMimeTypes);
    }

    protected final T format() {
        return this.format;
    }

    protected final List<MimeType> supportedMimeTypes() {
        return this.supportedMimeTypes;
    }

    protected final boolean canSerialize(ResolvableType type, @Nullable MimeType mimeType) {
        KSerializer<Object> serializer = this.serializer(type);
        if (serializer == null) {
            return false;
        }
        return this.supports(mimeType) && !String.class.isAssignableFrom(type.toClass()) && !ServerSentEvent.class.isAssignableFrom(type.toClass());
    }

    private boolean supports(@Nullable MimeType mimeType) {
        if (mimeType == null) {
            return true;
        }
        for (MimeType candidate : this.supportedMimeTypes) {
            if (!candidate.isCompatibleWith(mimeType)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    protected final KSerializer<Object> serializer(ResolvableType resolvableType) {
        Type type = resolvableType.getType();
        KSerializer serializer = this.serializerCache.get(type);
        if (serializer == null) {
            try {
                serializer = SerializersKt.serializerOrNull((SerializersModule)this.format.getSerializersModule(), (Type)type);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (serializer != null) {
                if (KotlinSerializationSupport.hasPolymorphism(serializer.getDescriptor(), new HashSet<String>())) {
                    return null;
                }
                this.serializerCache.put(type, (KSerializer<Object>)serializer);
            }
        }
        return serializer;
    }

    private static boolean hasPolymorphism(SerialDescriptor descriptor, Set<String> alreadyProcessed) {
        alreadyProcessed.add(descriptor.getSerialName());
        if (descriptor.getKind().equals(PolymorphicKind.OPEN.INSTANCE)) {
            return true;
        }
        for (int i = 0; i < descriptor.getElementsCount(); ++i) {
            SerialDescriptor elementDescriptor = descriptor.getElementDescriptor(i);
            if (alreadyProcessed.contains(elementDescriptor.getSerialName()) || !KotlinSerializationSupport.hasPolymorphism(elementDescriptor, alreadyProcessed)) continue;
            return true;
        }
        return false;
    }
}

