/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.util;

import io.camunda.zeebe.model.bpmn.instance.Activity;
import io.camunda.zeebe.model.bpmn.instance.BoundaryEvent;
import io.camunda.zeebe.model.bpmn.instance.BpmnModelElementInstance;
import io.camunda.zeebe.model.bpmn.instance.CallActivity;
import io.camunda.zeebe.model.bpmn.instance.ErrorEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.EscalationEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.EventDefinition;
import io.camunda.zeebe.model.bpmn.instance.IntermediateCatchEvent;
import io.camunda.zeebe.model.bpmn.instance.IntermediateThrowEvent;
import io.camunda.zeebe.model.bpmn.instance.LinkEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.Message;
import io.camunda.zeebe.model.bpmn.instance.MessageEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.Signal;
import io.camunda.zeebe.model.bpmn.instance.SignalEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.StartEvent;
import io.camunda.zeebe.model.bpmn.instance.SubProcess;
import io.camunda.zeebe.model.bpmn.instance.TimerEventDefinition;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public class ModelUtil {
    private static final List<Class<? extends EventDefinition>> NON_INTERRUPTING_EVENT_DEFINITIONS = Arrays.asList(MessageEventDefinition.class, TimerEventDefinition.class, SignalEventDefinition.class, EscalationEventDefinition.class);
    private static final List<Class<? extends Activity>> ESCALATION_BOUNDARY_EVENT_SUPPORTED_ACTIVITIES = Arrays.asList(SubProcess.class, CallActivity.class);

    public static List<EventDefinition> getEventDefinitionsForBoundaryEvents(Activity element) {
        return element.getBoundaryEvents().stream().flatMap(event -> event.getEventDefinitions().stream()).collect(Collectors.toList());
    }

    public static List<EventDefinition> getEventDefinitionsForEventSubprocesses(ModelElementInstance element) {
        return element.getChildElementsByType(SubProcess.class).stream().filter(SubProcess::triggeredByEvent).flatMap(subProcess -> subProcess.getChildElementsByType(StartEvent.class).stream()).flatMap(s -> s.getEventDefinitions().stream()).collect(Collectors.toList());
    }

    public static List<EventDefinition> getEventDefinitionsForSignalStartEvents(ModelElementInstance element) {
        return element.getChildElementsByType(StartEvent.class).stream().flatMap(i -> i.getEventDefinitions().stream()).filter(e -> e instanceof SignalEventDefinition).collect(Collectors.toList());
    }

    public static List<EventDefinition> getEventDefinitionsForLinkCatchEvents(ModelElementInstance element) {
        List<EventDefinition> definitions = element.getChildElementsByType(IntermediateCatchEvent.class).stream().flatMap(i -> i.getEventDefinitions().stream()).filter(e -> e instanceof LinkEventDefinition).collect(Collectors.toList());
        element.getChildElementsByType(SubProcess.class).stream().map(ModelUtil::getEventDefinitionsForLinkCatchEvents).forEach(definitions::addAll);
        return definitions;
    }

    public static List<EventDefinition> getEventDefinitionsForLinkThrowEvents(ModelElementInstance element) {
        return element.getChildElementsByType(IntermediateThrowEvent.class).stream().flatMap(i -> i.getEventDefinitions().stream()).filter(e -> e instanceof LinkEventDefinition).collect(Collectors.toList());
    }

    public static void verifyNoDuplicatedBoundaryEvents(Activity activity, Consumer<String> errorCollector) {
        List<EventDefinition> definitions = ModelUtil.getEventDefinitionsForBoundaryEvents(activity);
        ModelUtil.verifyNoDuplicatedEventDefinition(definitions, errorCollector);
        ModelUtil.verifyNoDuplicatedEscalationHandler(definitions, errorCollector);
        ModelUtil.verifyNoDuplicatedErrorHandler(definitions, errorCollector);
    }

    public static void verifyNoDuplicateSignalStartEvents(ModelElementInstance element, Consumer<String> errorCollector) {
        List<EventDefinition> definitions = ModelUtil.getEventDefinitionsForSignalStartEvents(element);
        ModelUtil.verifyNoDuplicatedEventDefinition(definitions, errorCollector);
    }

    public static void verifyLinkIntermediateEvents(ModelElementInstance element, Consumer<String> errorCollector) {
        List<EventDefinition> linkCatchEvents = ModelUtil.getEventDefinitionsForLinkCatchEvents(element);
        ModelUtil.verifyNoDuplicatedEventDefinition(linkCatchEvents, errorCollector);
        List<EventDefinition> linkThrowEvents = ModelUtil.getEventDefinitionsForLinkThrowEvents(element);
        Map<BpmnModelElementInstance, Set<String>> catchEventsGroupByScope = ModelUtil.groupEventsByScope(linkCatchEvents);
        Map<BpmnModelElementInstance, Set<String>> throwEventsGroupByScope = ModelUtil.groupEventsByScope(linkThrowEvents);
        ModelUtil.verifyCatchEventExistsInThrowEventScope(catchEventsGroupByScope, throwEventsGroupByScope, errorCollector);
    }

    private static Map<BpmnModelElementInstance, Set<String>> groupEventsByScope(List<EventDefinition> events) {
        return ModelUtil.getEventDefinition(events, LinkEventDefinition.class).filter(def -> def.getName() != null && !def.getName().isEmpty()).collect(Collectors.groupingBy(BpmnModelElementInstance::getScope, Collectors.mapping(LinkEventDefinition::getName, Collectors.toSet())));
    }

    private static void verifyCatchEventExistsInThrowEventScope(Map<BpmnModelElementInstance, Set<String>> catchEventsGroupByScope, Map<BpmnModelElementInstance, Set<String>> throwEventsGroupByScope, Consumer<String> errorCollector) {
        throwEventsGroupByScope.forEach((scope, items) -> {
            for (String item : items) {
                if (catchEventsGroupByScope.getOrDefault(scope, Collections.emptySet()).contains(item)) continue;
                errorCollector.accept(ModelUtil.noPairedLinkNames(item));
            }
        });
    }

    public static void verifyEventDefinition(BoundaryEvent boundaryEvent, Consumer<String> errorCollector) {
        boundaryEvent.getEventDefinitions().forEach(definition -> {
            if (definition instanceof EscalationEventDefinition) {
                ModelUtil.verifyEscalationBoundaryEvent(boundaryEvent, errorCollector);
            }
            ModelUtil.verifyEventDefinition(definition, boundaryEvent.cancelActivity(), errorCollector);
        });
    }

    public static void verifyEventDefinition(StartEvent startEvent, Consumer<String> errorCollector) {
        startEvent.getEventDefinitions().forEach(definition -> ModelUtil.verifyEventDefinition(definition, startEvent.isInterrupting(), errorCollector));
    }

    public static void verifyNoDuplicatedEventSubprocesses(ModelElementInstance element, Consumer<String> errorCollector) {
        List<EventDefinition> definitions = ModelUtil.getEventDefinitionsForEventSubprocesses(element);
        ModelUtil.verifyNoDuplicatedEventDefinition(definitions, errorCollector);
        ModelUtil.verifyNoDuplicatedEscalationHandler(definitions, errorCollector);
        ModelUtil.verifyNoDuplicatedErrorHandler(definitions, errorCollector);
    }

    public static void verifyNoDuplicatedEventDefinition(Collection<? extends EventDefinition> definitions, Consumer<String> errorCollector) {
        Stream<String> messageNames = ModelUtil.getEventDefinition(definitions, MessageEventDefinition.class).filter(def -> def.getMessage() != null).map(MessageEventDefinition::getMessage).filter(message -> message.getName() != null && !message.getName().isEmpty()).map(Message::getName);
        ModelUtil.getDuplicatedEntries(messageNames).map(ModelUtil::duplicatedMessageNames).forEach(errorCollector);
        Stream<String> signalNames = ModelUtil.getEventDefinition(definitions, SignalEventDefinition.class).filter(def -> def.getSignal() != null).map(SignalEventDefinition::getSignal).filter(signal -> signal.getName() != null && !signal.getName().isEmpty()).map(Signal::getName);
        ModelUtil.getDuplicatedEntries(signalNames).map(ModelUtil::duplicatedSignalNames).forEach(errorCollector);
        Stream<String> linkNames = ModelUtil.getEventDefinition(definitions, LinkEventDefinition.class).filter(def -> def.getName() != null && !def.getName().isEmpty()).map(LinkEventDefinition::getName);
        ModelUtil.getDuplicatedEntries(linkNames).map(ModelUtil::duplicatedLinkNames).forEach(errorCollector);
    }

    private static void verifyNoDuplicatedEscalationHandler(List<EventDefinition> definitions, Consumer<String> errorCollector) {
        List escalations = ModelUtil.getEventDefinition(definitions, EscalationEventDefinition.class).map(EscalationEventDefinition::getEscalation).collect(Collectors.toList());
        if (escalations.isEmpty()) {
            return;
        }
        long definitionWithoutEscalationCount = escalations.stream().filter(Objects::isNull).count();
        if (definitionWithoutEscalationCount > 1L) {
            errorCollector.accept("The same scope can not contain more than one escalation catch event without escalation code. An escalation catch event without escalation code catches all escalations.");
        }
        Map<Optional, Long> escalationCodeOccurrences = escalations.stream().filter(Objects::nonNull).map(escalation -> Optional.ofNullable(escalation.getEscalationCode())).collect(Collectors.groupingBy(escalationCode -> escalationCode, Collectors.counting()));
        escalationCodeOccurrences.forEach((escalationCode, occurrences) -> {
            if (occurrences > 1L) {
                errorCollector.accept(escalationCode.isPresent() ? String.format("Multiple escalation catch events with the same escalation code '%s' are not supported on the same scope.", escalationCode.get()) : "The same scope can not contain more than one escalation catch event without escalation code. An escalation catch event without escalation code catches all escalations.");
            }
        });
    }

    private static void verifyNoDuplicatedErrorHandler(List<EventDefinition> definitions, Consumer<String> errorCollector) {
        List errors = ModelUtil.getEventDefinition(definitions, ErrorEventDefinition.class).map(ErrorEventDefinition::getError).collect(Collectors.toList());
        if (errors.isEmpty()) {
            return;
        }
        long definitionWithoutErrorCount = errors.stream().filter(Objects::isNull).count();
        if (definitionWithoutErrorCount > 1L) {
            errorCollector.accept("The same scope can not contain more than one error catch event without error code. An error catch event without error code catches all errors.");
        }
        Map<Optional, Long> errorCodeOccurrences = errors.stream().filter(Objects::nonNull).map(error -> Optional.ofNullable(error.getErrorCode())).collect(Collectors.groupingBy(errorCode -> errorCode, Collectors.counting()));
        errorCodeOccurrences.forEach((errorCode, occurrences) -> {
            if (occurrences > 1L) {
                errorCollector.accept(errorCode.isPresent() ? String.format("Multiple error catch events with the same error code '%s' are not supported on the same scope.", errorCode.get()) : "The same scope can not contain more than one error catch event without error code. An error catch event without error code catches all errors.");
            }
        });
    }

    public static <T extends EventDefinition> Stream<T> getEventDefinition(Collection<? extends EventDefinition> collection, Class<T> type) {
        return collection.stream().filter(type::isInstance).map(type::cast);
    }

    public static Stream<String> getDuplicatedEntries(Stream<String> stream) {
        return stream.collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(Map.Entry::getKey);
    }

    private static String duplicatedMessageNames(String messageName) {
        return String.format("Multiple message event definitions with the same name '%s' are not allowed.", messageName);
    }

    private static String duplicatedSignalNames(String signalName) {
        return String.format("Multiple signal event definitions with the same name '%s' are not allowed.", signalName);
    }

    private static String duplicatedLinkNames(String linkName) {
        return String.format("Multiple intermediate catch link event definitions with the same name '%s' are not allowed.", linkName);
    }

    private static String noPairedLinkNames(String linkName) {
        return String.format("Can't find an catch link event for the throw link event with the name '%s'.", linkName);
    }

    private static void verifyEventDefinition(EventDefinition definition, boolean isInterrupting, Consumer<String> errorCollector) {
        TimerEventDefinition timerEventDefinition;
        if (!isInterrupting && !NON_INTERRUPTING_EVENT_DEFINITIONS.contains(definition.getElementType().getInstanceType())) {
            errorCollector.accept("Non-Interrupting event of this type is not allowed");
        }
        if (isInterrupting && definition instanceof TimerEventDefinition && (timerEventDefinition = (TimerEventDefinition)definition).getTimeCycle() != null) {
            errorCollector.accept("Interrupting timer event with time cycle is not allowed.");
        }
    }

    private static void verifyEscalationBoundaryEvent(BoundaryEvent element, Consumer<String> errorCollector) {
        if (ESCALATION_BOUNDARY_EVENT_SUPPORTED_ACTIVITIES.stream().noneMatch(activity -> activity.isInstance(element.getAttachedTo()))) {
            errorCollector.accept("An escalation boundary event should only be attached to a subprocess, or a call activity.");
        }
    }
}

