/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.impl;

import io.camunda.zeebe.model.bpmn.BpmnModelException;
import io.camunda.zeebe.model.bpmn.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.type.ModelElementType;

public class QueryImpl<T extends ModelElementInstance>
implements Query<T> {
    private final Collection<T> collection;

    public QueryImpl(Collection<T> collection) {
        this.collection = collection;
    }

    @Override
    public Stream<T> stream() {
        return this.collection.stream();
    }

    @Override
    public List<T> list() {
        return new ArrayList<T>(this.collection);
    }

    @Override
    public int count() {
        return this.collection.size();
    }

    @Override
    public <V extends ModelElementInstance> Query<V> filterByType(ModelElementType elementType) {
        Class<? extends ModelElementInstance> elementClass = elementType.getInstanceType();
        return this.filterByType(elementClass);
    }

    @Override
    public <V extends ModelElementInstance> Query<V> filterByType(Class<V> elementClass) {
        ArrayList<ModelElementInstance> filtered = new ArrayList<ModelElementInstance>();
        for (ModelElementInstance instance : this.collection) {
            if (!elementClass.isAssignableFrom(instance.getClass())) continue;
            filtered.add(instance);
        }
        return new QueryImpl(filtered);
    }

    @Override
    public T singleResult() {
        Optional<T> optionalSingleResult = this.findSingleResult();
        if (optionalSingleResult.isPresent()) {
            return (T)((ModelElementInstance)optionalSingleResult.get());
        }
        throw new BpmnModelException("Collection expected to have <1> entry but has <" + this.collection.size() + ">");
    }

    @Override
    public Optional<T> findSingleResult() {
        if (this.collection.size() == 1) {
            return Optional.of((ModelElementInstance)this.collection.iterator().next());
        }
        return Optional.empty();
    }
}

