/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter.visitor;

import org.camunda.community.migration.converter.DomElementVisitorContext;
import org.camunda.community.migration.converter.visitor.AbstractFilteringVisitor;

public abstract class AbstractAttributeVisitor
extends AbstractFilteringVisitor {
    @Override
    protected void visitFilteredElement(DomElementVisitorContext context) {
        String attribute = context.getElement().getAttribute(this.namespaceUri(), this.attributeLocalName());
        this.visitAttribute(context, attribute);
        if (this.removeAttribute(context)) {
            context.addAttributeToRemove(this.attributeLocalName(), this.namespaceUri());
        }
    }

    private String resolveAttribute(DomElementVisitorContext context) {
        return context.getElement().getAttribute(this.namespaceUri(), this.attributeLocalName());
    }

    @Override
    protected boolean canVisit(DomElementVisitorContext context) {
        return this.resolveAttribute(context) != null && context.getElement().getNamespaceURI().equals("http://www.omg.org/spec/BPMN/20100524/MODEL");
    }

    protected abstract String namespaceUri();

    public abstract String attributeLocalName();

    protected abstract void visitAttribute(DomElementVisitorContext var1, String var2);

    protected abstract boolean removeAttribute(DomElementVisitorContext var1);

    @Override
    protected void logVisit(DomElementVisitorContext context) {
        this.LOG.debug("Visiting attribute 'camunda:{}' on element '{}:{}'", this.attributeLocalName(), context.getElement().getPrefix(), context.getElement().getLocalName());
    }
}

