/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter.visitor.impl;

import java.util.function.Consumer;
import org.camunda.bpm.model.xml.instance.DomElement;
import org.camunda.community.migration.converter.DomElementVisitorContext;
import org.camunda.community.migration.converter.version.SemanticVersion;
import org.camunda.community.migration.converter.visitor.AbstractBpmnElementVisitor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefinitionsVisitor
extends AbstractBpmnElementVisitor {
    private static final String VERSION_HEADER = "executionPlatformVersion";
    private static final String PLATFORM_HEADER = "executionPlatform";
    private static final String CONVERTER_VERSION_HEADER = "converterVersion";
    private static final String PLATFORM_VALUE = "Camunda Cloud";
    private static final String ZEEBE_NAMESPACE_NAME = "zeebe";
    private static final String CONVERSION_NAMESPACE_NAME = "conversion";
    private static final String MODELER_NAMESPACE_NAME = "modeler";

    @Override
    protected void visitBpmnElement(DomElementVisitorContext context) {
        SemanticVersion desiredVersion = SemanticVersion.parse(context.getProperties().getPlatformVersion());
        DomElement element = context.getElement();
        String executionPlatform = element.getAttribute("http://camunda.org/schema/modeler/1.0", VERSION_HEADER);
        if (executionPlatform != null && executionPlatform.startsWith("8")) {
            throw new RuntimeException("This diagram is already a Camunda 8 diagram");
        }
        element.registerNamespace(MODELER_NAMESPACE_NAME, "http://camunda.org/schema/modeler/1.0");
        element.registerNamespace(ZEEBE_NAMESPACE_NAME, "http://camunda.org/schema/zeebe/1.0");
        element.registerNamespace(CONVERSION_NAMESPACE_NAME, "http://camunda.org/schema/conversion/1.0");
        element.setAttribute("http://camunda.org/schema/modeler/1.0", PLATFORM_HEADER, PLATFORM_VALUE);
        element.setAttribute("http://camunda.org/schema/modeler/1.0", VERSION_HEADER, desiredVersion.getPatchZeroVersion());
        element.setAttribute("http://camunda.org/schema/conversion/1.0", CONVERTER_VERSION_HEADER, this.getClass().getPackage().getImplementationVersion());
    }

    private void setNamespace(Node root, String oldPrefix) {
        this.visitChildren(root.getChildNodes(), element -> {
            String type;
            if (element.getPrefix() == null || element.getPrefix().trim().equals(oldPrefix)) {
                element.setPrefix("bpmn");
            }
            if (!(type = element.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type")).equals("")) {
                String[] split = type.split(":");
                element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type", "bpmn:" + split[split.length - 1]);
            }
        });
        Object xmlns = oldPrefix.equals("") ? "xmlns" : "xmlns:" + oldPrefix;
        this.visitChildren(root.getChildNodes(), arg_0 -> DefinitionsVisitor.lambda$setNamespace$1((String)xmlns, arg_0));
    }

    private void visitChildren(NodeList nodeList, Consumer<Element> action) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.visitChild(nodeList.item(i), action);
            this.visitChildren(nodeList.item(i).getChildNodes(), action);
        }
    }

    private void visitChild(Node node, Consumer<Element> action) {
        if (node instanceof Element) {
            Element element = (Element)node;
            action.accept(element);
        }
    }

    @Override
    protected SemanticVersion availableFrom(DomElementVisitorContext context) {
        return SemanticVersion._8_0;
    }

    @Override
    public String localName() {
        return "definitions";
    }

    private static /* synthetic */ void lambda$setNamespace$1(String xmlns, Element element) {
        element.removeAttribute(xmlns);
    }
}

