/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter.webapp;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.camunda.bpm.model.xml.ModelInstance;
import org.camunda.bpm.model.xml.instance.DomDocument;
import org.camunda.community.migration.converter.ConverterProperties;
import org.camunda.community.migration.converter.ConverterPropertiesFactory;
import org.camunda.community.migration.converter.DefaultConverterProperties;
import org.camunda.community.migration.converter.DiagramCheckResult;
import org.camunda.community.migration.converter.DiagramConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DiagramConverterService {
    private final DiagramConverter diagramConverter;

    @Autowired
    public DiagramConverterService(DiagramConverter diagramConverter) {
        this.diagramConverter = diagramConverter;
    }

    public void convert(ModelInstance modelInstance, boolean appendDocumentation, String defaultJobType, String platformVersion, Boolean defaultJobTypeEnabled) {
        DefaultConverterProperties adaptedProperties = new DefaultConverterProperties();
        adaptedProperties.setDefaultJobType(defaultJobType);
        adaptedProperties.setPlatformVersion(platformVersion);
        adaptedProperties.setDefaultJobTypeEnabled(defaultJobTypeEnabled);
        adaptedProperties.setAppendDocumentation(Boolean.valueOf(appendDocumentation));
        this.diagramConverter.convert(modelInstance, ConverterPropertiesFactory.getInstance().merge((ConverterProperties)adaptedProperties));
    }

    public DiagramCheckResult check(String filename, ModelInstance modelInstance, String defaultJobType, String platformVersion, Boolean defaultJobTypeEnabled) {
        DefaultConverterProperties adaptedProperties = new DefaultConverterProperties();
        adaptedProperties.setDefaultJobType(defaultJobType);
        adaptedProperties.setPlatformVersion(platformVersion);
        adaptedProperties.setDefaultJobTypeEnabled(defaultJobTypeEnabled);
        return this.diagramConverter.check(filename, modelInstance, ConverterPropertiesFactory.getInstance().merge((ConverterProperties)adaptedProperties));
    }

    public String printXml(DomDocument document, boolean prettyPrint) {
        String string;
        StringWriter sw = new StringWriter();
        try {
            this.diagramConverter.printXml(document, prettyPrint, (Writer)sw);
            string = sw.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    sw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        sw.close();
        return string;
    }

    public void writeCsvFile(List<DiagramCheckResult> results, Writer writer) {
        this.diagramConverter.writeCsvFile(results, writer);
    }
}

