/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.converter.webapp;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.xml.instance.DomDocument;
import org.camunda.community.converter.BpmnConverter;
import org.camunda.community.converter.BpmnDiagramCheckResult;
import org.camunda.community.converter.ConverterPropertiesFactory;
import org.camunda.community.converter.DefaultConverterProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BpmnConverterService {
    private final BpmnConverter bpmnConverter;

    @Autowired
    public BpmnConverterService(BpmnConverter bpmnConverter) {
        this.bpmnConverter = bpmnConverter;
    }

    public void convert(BpmnModelInstance modelInstance, boolean appendDocumentation, String adapterJobType, String platformVersion) {
        DefaultConverterProperties adaptedProperties = new DefaultConverterProperties();
        adaptedProperties.setAdapterJobType(adapterJobType);
        this.bpmnConverter.convert(modelInstance, appendDocumentation, ConverterPropertiesFactory.getInstance().merge(adaptedProperties));
    }

    public BpmnDiagramCheckResult check(String filename, BpmnModelInstance modelInstance, boolean appendDocumentation, String adapterJobType, String platformVersion) {
        DefaultConverterProperties adaptedProperties = new DefaultConverterProperties();
        adaptedProperties.setAdapterJobType(adapterJobType);
        return this.bpmnConverter.check(filename, modelInstance, appendDocumentation, ConverterPropertiesFactory.getInstance().merge(adaptedProperties));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String printXml(DomDocument document, boolean prettyPrint) {
        try (StringWriter sw = new StringWriter();){
            this.bpmnConverter.printXml(document, prettyPrint, (Writer)sw);
            String string = sw.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

