/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter.webapp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.community.migration.converter.BpmnDiagramCheckResult;
import org.camunda.community.migration.converter.webapp.BpmnConverterService;
import org.camunda.community.migration.converter.webapp.CsvWriterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class ConverterController {
    private final BpmnConverterService bpmnConverter;
    private final CsvWriterService csvWriterService;

    @Autowired
    public ConverterController(BpmnConverterService bpmnConverter, CsvWriterService csvWriterService) {
        this.bpmnConverter = bpmnConverter;
        this.csvWriterService = csvWriterService;
    }

    @PostMapping(value={"/check"}, produces={"application/json", "text/csv"}, consumes={"multipart/form-data"})
    public ResponseEntity<?> check(@RequestParam(value="files") MultipartFile[] bpmnFiles, @RequestParam(value="adapterJobType", required=false) String adapterJobType, @RequestParam(value="platformVersion", required=false) String platformVersion, @RequestHeader(value="Accept") String[] contentType) {
        List<BpmnDiagramCheckResult> results = Arrays.stream(bpmnFiles).map(bpmnFile -> {
            try (InputStream in = bpmnFile.getInputStream();){
                BpmnDiagramCheckResult throwable3 = this.bpmnConverter.check(bpmnFile.getOriginalFilename(), Bpmn.readModelFromStream((InputStream)in), false, adapterJobType, platformVersion);
                return throwable3;
            }
            catch (IOException e) {
                BpmnDiagramCheckResult result = new BpmnDiagramCheckResult();
                result.setFilename(bpmnFile.getOriginalFilename());
                return result;
            }
        }).collect(Collectors.toList());
        if (contentType == null || contentType.length == 0 || Arrays.asList(contentType).contains("application/json")) {
            return ResponseEntity.ok(results);
        }
        if (Arrays.asList(contentType).contains("text/csv")) {
            StringWriter sw = new StringWriter();
            this.csvWriterService.writeCsvFile(results, sw);
            ByteArrayResource file = new ByteArrayResource(sw.toString().getBytes());
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"conversionResult.csv\""})).contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)file);
        }
        return ResponseEntity.badRequest().build();
    }

    @PostMapping(value={"/convert"}, produces={"application/octet-stream"}, consumes={"multipart/form-data"})
    public ResponseEntity<?> getFile(@RequestParam(value="files") MultipartFile[] bpmnFiles, @RequestParam(value="appendDocumentation") boolean appendDocumentation, @RequestParam(value="adapterJobType", required=false) String adapterJobType, @RequestParam(value="platformVersion", required=false) String platformVersion) {
        HashMap<MultipartFile, Exception> exceptions = new HashMap<MultipartFile, Exception>();
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try (ZipOutputStream out = new ZipOutputStream(bo);){
            for (MultipartFile bpmnFile : bpmnFiles) {
                try (InputStream in = bpmnFile.getInputStream();){
                    BpmnModelInstance modelInstance = Bpmn.readModelFromStream((InputStream)in);
                    this.bpmnConverter.convert(modelInstance, appendDocumentation, adapterJobType, platformVersion);
                    ZipEntry entry = new ZipEntry("converted-c8-" + bpmnFile.getOriginalFilename());
                    out.putNextEntry(entry);
                    out.write(this.bpmnConverter.printXml(modelInstance.getDocument(), true).getBytes());
                }
                catch (Exception e2) {
                    exceptions.put(bpmnFile, e2);
                }
            }
        }
        catch (IOException e3) {
            return ResponseEntity.internalServerError().body((Object)e3.getMessage());
        }
        if (exceptions.isEmpty()) {
            ByteArrayResource file = new ByteArrayResource(bo.toByteArray());
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"conversionResult.zip\""})).contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)file);
        }
        return ResponseEntity.badRequest().body(exceptions.entrySet().stream().map(e -> new AbstractMap.SimpleEntry(((MultipartFile)e.getKey()).getOriginalFilename(), e.getValue())).collect(Collectors.toList()));
    }
}

