/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter.webapp;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.xml.instance.DomDocument;
import org.camunda.community.migration.converter.BpmnConverter;
import org.camunda.community.migration.converter.BpmnDiagramCheckResult;
import org.camunda.community.migration.converter.ConverterPropertiesFactory;
import org.camunda.community.migration.converter.DefaultConverterProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BpmnConverterService {
    private final BpmnConverter bpmnConverter;

    @Autowired
    public BpmnConverterService(BpmnConverter bpmnConverter) {
        this.bpmnConverter = bpmnConverter;
    }

    public void convert(BpmnModelInstance modelInstance, boolean appendDocumentation, String adapterJobType, String platformVersion) {
        DefaultConverterProperties adaptedProperties = new DefaultConverterProperties();
        adaptedProperties.setAdapterJobType(adapterJobType);
        adaptedProperties.setPlatformVersion(platformVersion);
        this.bpmnConverter.convert(modelInstance, appendDocumentation, ConverterPropertiesFactory.getInstance().merge(adaptedProperties));
    }

    public BpmnDiagramCheckResult check(String filename, BpmnModelInstance modelInstance, boolean appendDocumentation, String adapterJobType, String platformVersion) {
        DefaultConverterProperties adaptedProperties = new DefaultConverterProperties();
        adaptedProperties.setAdapterJobType(adapterJobType);
        adaptedProperties.setPlatformVersion(platformVersion);
        return this.bpmnConverter.check(filename, modelInstance, appendDocumentation, ConverterPropertiesFactory.getInstance().merge(adaptedProperties));
    }

    public String printXml(DomDocument document, boolean prettyPrint) {
        String string;
        StringWriter sw = new StringWriter();
        try {
            this.bpmnConverter.printXml(document, prettyPrint, (Writer)sw);
            string = sw.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    sw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        sw.close();
        return string;
    }

    public void writeCsvFile(List<BpmnDiagramCheckResult> results, Writer writer) {
        this.bpmnConverter.writeCsvFile(results, writer);
    }
}

