/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter.webapp;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.community.migration.converter.BpmnDiagramCheckResult;
import org.camunda.community.migration.converter.webapp.BpmnConverterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.info.BuildProperties;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class ConverterController {
    private static final Logger LOG = LoggerFactory.getLogger(ConverterController.class);
    private final BpmnConverterService bpmnConverter;
    private final BuildProperties buildProperties;

    @Autowired
    public ConverterController(BpmnConverterService bpmnConverter, BuildProperties buildProperties) {
        this.bpmnConverter = bpmnConverter;
        this.buildProperties = buildProperties;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping(value={"/check"}, produces={"application/json", "text/csv"}, consumes={"multipart/form-data"})
    public ResponseEntity<?> check(@RequestParam(value="file") MultipartFile bpmnFile, @RequestParam(value="adapterJobType", required=false) String adapterJobType, @RequestParam(value="platformVersion", required=false) String platformVersion, @RequestHeader(value="Accept") String[] contentType) {
        try (InputStream in = bpmnFile.getInputStream();){
            BpmnDiagramCheckResult diagramCheckResult = this.bpmnConverter.check(bpmnFile.getOriginalFilename(), Bpmn.readModelFromStream((InputStream)in), false, adapterJobType, platformVersion);
            if (contentType == null || contentType.length == 0 || Arrays.asList(contentType).contains("application/json")) {
                ResponseEntity responseEntity = ResponseEntity.ok((Object)diagramCheckResult);
                return responseEntity;
            }
            if (Arrays.asList(contentType).contains("text/csv")) {
                StringWriter sw = new StringWriter();
                this.bpmnConverter.writeCsvFile(Collections.singletonList(diagramCheckResult), (Writer)sw);
                ByteArrayResource file = new ByteArrayResource(sw.toString().getBytes());
                ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"conversionResult.csv\""})).contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)file);
                return responseEntity;
            }
            ResponseEntity responseEntity = ResponseEntity.badRequest().build();
            return responseEntity;
        }
        catch (IOException e) {
            LOG.error("Error while reading input stream of BPMN file", (Throwable)e);
            return ResponseEntity.badRequest().body((Object)e.getMessage());
        }
    }

    @PostMapping(value={"/convert"}, produces={"application/bpmn+xml"}, consumes={"multipart/form-data"})
    public ResponseEntity<?> getFile(@RequestParam(value="file") MultipartFile bpmnFile, @RequestParam(value="appendDocumentation") boolean appendDocumentation, @RequestParam(value="adapterJobType", required=false) String adapterJobType, @RequestParam(value="platformVersion", required=false) String platformVersion) {
        ResponseEntity responseEntity;
        block9: {
            InputStream in = bpmnFile.getInputStream();
            try {
                BpmnModelInstance modelInstance = Bpmn.readModelFromStream((InputStream)in);
                this.bpmnConverter.convert(modelInstance, appendDocumentation, adapterJobType, platformVersion);
                String bpmnXml = this.bpmnConverter.printXml(modelInstance.getDocument(), true);
                ByteArrayResource file = new ByteArrayResource(bpmnXml.getBytes());
                responseEntity = ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"converted-c8-" + bpmnFile.getOriginalFilename() + "\""})).header("Content-Type", new String[]{"application/bpmn+xml"})).body((Object)file);
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return ResponseEntity.badRequest().body((Object)e.getMessage());
                }
                catch (Exception e) {
                    return ResponseEntity.internalServerError().body((Object)e.getMessage());
                }
            }
            in.close();
        }
        return responseEntity;
    }

    @GetMapping(value={"/version"}, produces={"text/plain"})
    public ResponseEntity<String> getVersion() {
        String implementationVersion = this.buildProperties.getVersion();
        LOG.debug("Version: {}", (Object)implementationVersion);
        return ResponseEntity.ok().body((Object)implementationVersion);
    }
}

