/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.worker;

import io.camunda.zeebe.client.api.command.CompleteJobCommandStep1;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.worker.JobClient;
import io.camunda.zeebe.spring.client.annotation.ZeebeWorker;
import java.util.HashMap;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.community.migration.execution.ZeebeJobDelegateExecution;
import org.camunda.community.migration.juel.JuelExpressionResolver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CamundaPlatform7DelegationWorker {
    @Autowired
    private JuelExpressionResolver expressionResolver;

    @ZeebeWorker(type="camunda-7-adapter")
    public void delegateToCamundaPlatformCode(JobClient client, ActivatedJob job) throws Exception {
        JavaDelegate javaDelegate;
        String delegateClass = (String)job.getCustomHeaders().get("class");
        String delegateExpression = (String)job.getCustomHeaders().get("delegateExpression");
        String expression = (String)job.getCustomHeaders().get("expression");
        String resultVariable = (String)job.getCustomHeaders().get("resultVariable");
        HashMap<String, Object> resultPayload = null;
        DelegateExecution execution = this.wrapDelegateExecution(job);
        if (delegateClass != null) {
            javaDelegate = this.loadJavaDelegate(delegateClass);
            javaDelegate.execute(execution);
            resultPayload = execution.getVariables();
        } else if (delegateExpression != null) {
            javaDelegate = (JavaDelegate)this.expressionResolver.evaluate(delegateExpression, execution);
            javaDelegate.execute(execution);
            resultPayload = execution.getVariables();
        } else if (expression != null) {
            Object result = this.expressionResolver.evaluate(expression, execution);
            if (resultVariable != null) {
                resultPayload = new HashMap<String, Object>();
                resultPayload.put(resultVariable, result);
            }
        } else {
            throw new RuntimeException("Either 'class' or 'delegateExpression' or 'expression' must be specified in task headers for job :" + job);
        }
        CompleteJobCommandStep1 completeCommand = client.newCompleteCommand(job.getKey());
        if (resultPayload != null) {
            completeCommand.variables(resultPayload);
        }
        completeCommand.send().join();
    }

    private DelegateExecution wrapDelegateExecution(ActivatedJob job) {
        return new ZeebeJobDelegateExecution(job);
    }

    private JavaDelegate loadJavaDelegate(String delegateName) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = contextClassLoader.loadClass(delegateName);
            return (JavaDelegate)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load delegation class '" + delegateName + "': " + e.getMessage(), e);
        }
    }
}

