/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.adapter.execution.variable;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.camunda.community.migration.adapter.execution.variable.VariableTypingRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VariableTyper {
    private static final Logger LOG = LoggerFactory.getLogger(VariableTyper.class);
    private final Set<VariableTypingRule> rules;

    @Autowired
    public VariableTyper(Set<VariableTypingRule> rules) {
        this.rules = rules;
    }

    public Map<String, Object> typeVariables(String bpmnProcessId, Map<String, Object> variables) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        variables.forEach((variableName, variableValue) -> {
            LOG.debug("Handling variable {} of process {}", variableName, (Object)bpmnProcessId);
            DefaultVariableTypingContext context = new DefaultVariableTypingContext(bpmnProcessId, (String)variableName, variableValue);
            this.rules.forEach(rule -> rule.handle(context));
            result.put(context.getVariableName(), Optional.ofNullable(context.typedVariableValue).orElse(context.variableValue));
        });
        return result;
    }

    public static class DefaultVariableTypingContext
    implements VariableTypingRule.VariableTypingContext {
        private final String bpmnProcessId;
        private final String variableName;
        private final Object variableValue;
        private Object typedVariableValue;

        public DefaultVariableTypingContext(String bpmnProcessId, String variableName, Object variableValue) {
            this.bpmnProcessId = bpmnProcessId;
            this.variableName = variableName;
            this.variableValue = variableValue;
        }

        @Override
        public String getBpmnProcessId() {
            return this.bpmnProcessId;
        }

        @Override
        public String getVariableName() {
            return this.variableName;
        }

        @Override
        public Object getVariableValue() {
            return this.variableValue;
        }

        @Override
        public void setVariableValue(Object variableValue) {
            if (this.typedVariableValue != null) {
                throw new IllegalStateException(String.format("Multiple typings detected for variable %s on process %s", this.variableName, this.bpmnProcessId));
            }
            this.typedVariableValue = variableValue;
        }
    }
}

