/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.adapter.execution.variable;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Set;
import org.camunda.community.migration.adapter.execution.variable.GlobalVariableTypingRule;
import org.camunda.community.migration.adapter.execution.variable.VariableTypingRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MultiProcessVariableTypingRule
extends GlobalVariableTypingRule {
    private static final Logger LOG = LoggerFactory.getLogger(MultiProcessVariableTypingRule.class);

    @Override
    protected boolean contextMatches(VariableTypingRule.VariableTypingContext context) {
        return super.contextMatches(context) && this.bpmnProcessIdMatches(context);
    }

    private boolean bpmnProcessIdMatches(VariableTypingRule.VariableTypingContext context) {
        return this.bpmnProcessIds().contains(context.getBpmnProcessId());
    }

    protected abstract Set<String> bpmnProcessIds();

    public static class SimpleMultiProcessVariableTypingRule
    extends MultiProcessVariableTypingRule {
        private final Set<String> bpmnProcessIds;
        private final String variableName;
        private final ObjectMapper objectMapper;
        private final Class<?> targetType;

        public SimpleMultiProcessVariableTypingRule(Set<String> bpmnProcessIds, String variableName, ObjectMapper objectMapper, Class<?> targetType) {
            this.bpmnProcessIds = bpmnProcessIds;
            this.variableName = variableName;
            this.objectMapper = objectMapper;
            this.targetType = targetType;
        }

        @Override
        protected Class<?> targetType() {
            return this.targetType;
        }

        @Override
        protected ObjectMapper objectMapper() {
            return this.objectMapper;
        }

        @Override
        protected String variableName() {
            return this.variableName;
        }

        @Override
        protected Set<String> bpmnProcessIds() {
            return this.bpmnProcessIds;
        }
    }
}

