/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.adapter.juel;

import org.camunda.bpm.engine.ArtifactFactory;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.springframework.stereotype.Component;

@Component
public class ClassResolver {
    private final ArtifactFactory artifactFactory;

    public ClassResolver(ArtifactFactory artifactFactory) {
        this.artifactFactory = artifactFactory;
    }

    public JavaDelegate loadJavaDelegate(String delegateName) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = contextClassLoader.loadClass(delegateName);
            return (JavaDelegate)this.artifactFactory.getArtifact(clazz);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load delegation class '" + delegateName + "': " + e.getMessage(), e);
        }
    }

    public ExecutionListener loadExecutionListener(String listenerName) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = contextClassLoader.loadClass(listenerName);
            return (ExecutionListener)this.artifactFactory.getArtifact(clazz);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load listener class '" + listenerName + "': " + e.getMessage(), e);
        }
    }
}

