/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.externalTask;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.worker.JobClient;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.camunda.bpm.client.task.ExternalTask;
import org.camunda.bpm.client.task.ExternalTaskService;

public class JobClientWrappingExternalTaskService
implements ExternalTaskService {
    private final JobClient client;
    private final ExternalTask task;

    public JobClientWrappingExternalTaskService(JobClient client, ExternalTask task) {
        this.client = client;
        this.task = task;
    }

    public void lock(String externalTaskId, long lockDuration) {
        throw new UnsupportedOperationException();
    }

    public void lock(ExternalTask externalTask, long lockDuration) {
        this.lock(externalTask.getId(), lockDuration);
    }

    public void unlock(ExternalTask externalTask) {
        throw new UnsupportedOperationException();
    }

    public void complete(ExternalTask externalTask) {
        this.complete(externalTask.getId(), new HashMap<String, Object>(), new HashMap<String, Object>());
    }

    public void setVariables(String processInstanceId, Map<String, Object> variables) {
        this.setVariables(Optional.ofNullable(processInstanceId), false, variables);
    }

    private void setVariables(Optional<String> processInstanceId, boolean local, Map<String, Object> variables) {
        if (variables != null && !variables.isEmpty()) {
            if (this.client instanceof ZeebeClient) {
                ((ZeebeClient)this.client).newSetVariablesCommand(Long.parseLong(processInstanceId.orElse(this.task.getProcessInstanceId()))).variables(variables).local(local).send().join();
            } else {
                throw new UnsupportedOperationException();
            }
        }
    }

    public void setVariables(ExternalTask externalTask, Map<String, Object> variables) {
        this.setVariables(Optional.ofNullable(externalTask.getProcessInstanceId()), false, variables);
    }

    public void complete(ExternalTask externalTask, Map<String, Object> variables) {
        this.complete(externalTask.getId(), variables, null);
    }

    public void complete(ExternalTask externalTask, Map<String, Object> variables, Map<String, Object> localVariables) {
        this.complete(externalTask.getId(), variables, localVariables);
    }

    public void complete(String externalTaskId, Map<String, Object> variables, Map<String, Object> localVariables) {
        if (localVariables != null && !localVariables.isEmpty()) {
            this.setVariables(Optional.empty(), true, localVariables);
        }
        this.client.newCompleteCommand(Long.parseLong(externalTaskId)).variables(variables).send().join();
    }

    public void handleFailure(ExternalTask externalTask, String errorMessage, String errorDetails, int retries, long retryTimeout) {
        this.handleFailure(externalTask.getId(), errorMessage, errorDetails, retries, retryTimeout, null, null);
    }

    public void handleFailure(String externalTaskId, String errorMessage, String errorDetails, int retries, long retryTimeout) {
        this.handleFailure(externalTaskId, errorMessage, errorDetails, retries, retryTimeout, null, null);
    }

    public void handleFailure(String externalTaskId, String errorMessage, String errorDetails, int retries, long retryTimeout, Map<String, Object> variables, Map<String, Object> localVariables) {
        String composedErrorMessage = errorMessage + "\n\n" + errorDetails;
        this.setVariables(Optional.empty(), false, variables);
        this.setVariables(Optional.empty(), true, localVariables);
        this.client.newFailCommand(Long.parseLong(externalTaskId)).retries(retries).errorMessage(composedErrorMessage).requestTimeout(Duration.ofMillis(retryTimeout)).send().join();
    }

    public void handleBpmnError(ExternalTask externalTask, String errorCode) {
        this.handleBpmnError(externalTask.getId(), errorCode, null, null);
    }

    public void handleBpmnError(ExternalTask externalTask, String errorCode, String errorMessage) {
        this.handleBpmnError(externalTask.getId(), errorCode, errorMessage, null);
    }

    public void handleBpmnError(ExternalTask externalTask, String errorCode, String errorMessage, Map<String, Object> variables) {
        if (variables != null) {
            this.setVariables(externalTask, variables);
        }
        this.handleBpmnError(externalTask.getId(), errorCode, errorMessage, variables);
    }

    public void handleBpmnError(String externalTaskId, String errorCode, String errorMessage, Map<String, Object> variables) {
        this.setVariables(Optional.empty(), false, variables);
        this.client.newThrowErrorCommand(Long.parseLong(externalTaskId)).errorCode(errorCode).errorMessage(errorMessage).send().join();
    }

    public void extendLock(ExternalTask externalTask, long newDuration) {
        throw new UnsupportedOperationException();
    }

    public void extendLock(String externalTaskId, long newDuration) {
        throw new UnsupportedOperationException();
    }
}

