/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.externalTask;

import io.camunda.zeebe.client.api.response.ActivatedJob;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import org.camunda.bpm.client.task.ExternalTask;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.impl.VariableMapImpl;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class JobWrappingExternalTask
implements ExternalTask {
    private final ActivatedJob job;
    private final Optional<String> businessKeyVariableName;

    public JobWrappingExternalTask(ActivatedJob job, Optional<String> businessKeyVariableName) {
        this.job = job;
        this.businessKeyVariableName = businessKeyVariableName;
    }

    public String getActivityId() {
        return this.job.getElementId();
    }

    public String getActivityInstanceId() {
        return String.valueOf(this.job.getElementInstanceKey());
    }

    public String getErrorMessage() {
        throw new UnsupportedOperationException();
    }

    public String getErrorDetails() {
        throw new UnsupportedOperationException();
    }

    public String getExecutionId() {
        throw new UnsupportedOperationException();
    }

    public String getId() {
        return String.valueOf(this.job.getKey());
    }

    public Date getLockExpirationTime() {
        return Date.from(Instant.ofEpochMilli(this.job.getDeadline()));
    }

    public String getProcessDefinitionId() {
        return String.valueOf(this.job.getProcessDefinitionKey());
    }

    public String getProcessDefinitionKey() {
        return this.job.getBpmnProcessId();
    }

    public String getProcessDefinitionVersionTag() {
        throw new UnsupportedOperationException();
    }

    public String getProcessInstanceId() {
        return String.valueOf(this.job.getProcessInstanceKey());
    }

    public Integer getRetries() {
        return this.job.getRetries();
    }

    public String getWorkerId() {
        return this.job.getWorker();
    }

    public String getTopicName() {
        return this.job.getType();
    }

    public String getTenantId() {
        throw new UnsupportedOperationException();
    }

    public long getPriority() {
        throw new UnsupportedOperationException();
    }

    public <T> T getVariable(String s) {
        return (T)this.job.getVariablesAsMap().get(s);
    }

    public <T extends TypedValue> T getVariableTyped(String s) {
        return (T)this.getAllVariablesTyped().getValueTyped(s);
    }

    public <T extends TypedValue> T getVariableTyped(String s, boolean deserialize) {
        return (T)this.getAllVariablesTyped().getValueTyped(s);
    }

    public Map<String, Object> getAllVariables() {
        return this.job.getVariablesAsMap();
    }

    public VariableMap getAllVariablesTyped() {
        return new VariableMapImpl(this.job.getVariablesAsMap());
    }

    public VariableMap getAllVariablesTyped(boolean deserialize) {
        return this.getAllVariablesTyped();
    }

    public String getBusinessKey() {
        return this.businessKeyVariableName.map(businessKeyVar -> (String)this.getVariable((String)businessKeyVar)).orElseThrow(UnsupportedOperationException::new);
    }

    public String getExtensionProperty(String s) {
        return (String)this.job.getCustomHeaders().get(s);
    }

    public Map<String, String> getExtensionProperties() {
        return this.job.getCustomHeaders();
    }
}

