/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.adapter.worker;

import io.camunda.zeebe.client.api.command.CompleteJobCommandStep1;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.worker.JobClient;
import io.camunda.zeebe.spring.client.annotation.JobWorker;
import io.camunda.zeebe.spring.client.exception.ZeebeBpmnError;
import java.util.HashMap;
import org.camunda.bpm.engine.ArtifactFactory;
import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.community.migration.adapter.execution.ZeebeJobDelegateExecution;
import org.camunda.community.migration.adapter.juel.JuelExpressionResolver;
import org.springframework.stereotype.Component;

@Component
public class CamundaPlatform7DelegationWorker {
    private final JuelExpressionResolver expressionResolver;
    private final ArtifactFactory artifactFactory;

    public CamundaPlatform7DelegationWorker(JuelExpressionResolver expressionResolver, ArtifactFactory artifactFactory) {
        this.expressionResolver = expressionResolver;
        this.artifactFactory = artifactFactory;
    }

    @JobWorker(type="camunda-7-adapter", autoComplete=false)
    public void delegateToCamundaPlatformCode(JobClient client, ActivatedJob job) throws Exception {
        String delegateClass = (String)job.getCustomHeaders().get("class");
        String delegateExpression = (String)job.getCustomHeaders().get("delegateExpression");
        String expression = (String)job.getCustomHeaders().get("expression");
        String resultVariable = (String)job.getCustomHeaders().get("resultVariable");
        HashMap<String, Object> resultPayload = null;
        DelegateExecution execution = this.wrapDelegateExecution(job);
        DelegateExecution variableScope = this.wrapDelegateExecution(job);
        try {
            JavaDelegate javaDelegate;
            if (delegateClass != null) {
                javaDelegate = this.loadJavaDelegate(delegateClass);
                javaDelegate.execute(execution);
                resultPayload = execution.getVariables();
            } else if (delegateExpression != null) {
                javaDelegate = (JavaDelegate)this.expressionResolver.evaluate(delegateExpression, (VariableScope)variableScope, execution);
                javaDelegate.execute(execution);
                resultPayload = execution.getVariables();
            } else if (expression != null) {
                Object result = this.expressionResolver.evaluate(expression, (VariableScope)variableScope, execution);
                if (resultVariable != null) {
                    resultPayload = new HashMap<String, Object>();
                    resultPayload.put(resultVariable, result);
                }
            } else {
                throw new RuntimeException("Either 'class' or 'delegateExpression' or 'expression' must be specified in task headers for job :" + job);
            }
            CompleteJobCommandStep1 completeCommand = client.newCompleteCommand(job.getKey());
            if (resultPayload != null) {
                completeCommand.variables(resultPayload);
            }
            completeCommand.send().join();
        }
        catch (BpmnError e) {
            throw new ZeebeBpmnError(e.getErrorCode(), e.getMessage());
        }
    }

    private DelegateExecution wrapDelegateExecution(ActivatedJob job) {
        return new ZeebeJobDelegateExecution(job);
    }

    private JavaDelegate loadJavaDelegate(String delegateName) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = contextClassLoader.loadClass(delegateName);
            return (JavaDelegate)this.artifactFactory.getArtifact(clazz);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load delegation class '" + delegateName + "': " + e.getMessage(), e);
        }
    }
}

