/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.adapter.execution.variable;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.camunda.community.migration.adapter.execution.variable.AbstractVariableTypingRule;
import org.camunda.community.migration.adapter.execution.variable.VariableTypingRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GlobalVariableTypingRule
extends AbstractVariableTypingRule {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalVariableTypingRule.class);

    @Override
    protected boolean contextMatches(VariableTypingRule.VariableTypingContext context) {
        return this.variableNameMatches(context);
    }

    protected boolean variableNameMatches(VariableTypingRule.VariableTypingContext context) {
        return this.variableName() == null || this.variableName().equals(context.getVariableName());
    }

    protected abstract String variableName();

    public static class SimpleGlobalVariableTypingRule
    extends GlobalVariableTypingRule {
        private final String variableName;
        private final ObjectMapper objectMapper;
        private final Class<?> targetType;

        public SimpleGlobalVariableTypingRule(String variableName, ObjectMapper objectMapper, Class<?> targetType) {
            this.variableName = variableName;
            this.objectMapper = objectMapper;
            this.targetType = targetType;
        }

        @Override
        protected String variableName() {
            return this.variableName;
        }

        @Override
        protected ObjectMapper objectMapper() {
            return this.objectMapper;
        }

        @Override
        protected Class<?> targetType() {
            return this.targetType;
        }
    }
}

