/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.adapter.execution.variable;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.camunda.community.migration.adapter.execution.variable.VariableTypingRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractVariableTypingRule
implements VariableTypingRule {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());

    @Override
    public final void handle(VariableTypingRule.VariableTypingContext context) {
        if (this.contextMatches(context)) {
            this.LOG.debug("Converting variable {} of process {} from {} to {}", new Object[]{context.getVariableName(), context.getBpmnProcessId(), context.getVariableValue().getClass(), this.targetType(context)});
            Object newVariableValue = this.objectMapper(context).convertValue(context.getVariableValue(), this.targetType(context));
            context.setVariableValue(newVariableValue);
        }
    }

    protected abstract boolean contextMatches(VariableTypingRule.VariableTypingContext var1);

    protected Class<?> targetType(VariableTypingRule.VariableTypingContext context) {
        return this.targetType();
    }

    protected abstract Class<?> targetType();

    protected ObjectMapper objectMapper(VariableTypingRule.VariableTypingContext context) {
        return this.objectMapper();
    }

    protected abstract ObjectMapper objectMapper();
}

