/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.adapter;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.worker.JobHandler;
import io.camunda.zeebe.client.api.worker.JobWorker;
import io.camunda.zeebe.client.api.worker.JobWorkerBuilderStep1;
import io.camunda.zeebe.spring.client.annotation.processor.AbstractZeebeAnnotationProcessor;
import io.camunda.zeebe.spring.client.bean.ClassInfo;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.camunda.bpm.client.spring.impl.client.ClientConfiguration;
import org.camunda.bpm.client.spring.impl.subscription.SpringTopicSubscriptionImpl;
import org.camunda.community.migration.adapter.worker.ExternalTaskHandlerWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalTaskWorkerRegistration
extends AbstractZeebeAnnotationProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalTaskWorkerRegistration.class);
    private final ClientConfiguration clientConfiguration;
    private final Map<String, SpringTopicSubscriptionImpl> springTopicSubscriptions = new HashMap<String, SpringTopicSubscriptionImpl>();
    private final List<JobWorker> openedWorkers = new ArrayList<JobWorker>();

    public ExternalTaskWorkerRegistration(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = clientConfiguration;
    }

    private Long calculateLockDuration(SpringTopicSubscriptionImpl subscription) {
        Long lockDuration = this.clientConfiguration.getLockDuration();
        if (subscription.getLockDuration() != null && subscription.getLockDuration() < 0L) {
            lockDuration = subscription.getLockDuration();
        }
        return lockDuration;
    }

    private <T> void setIfPresent(T value, Consumer<T> setter) {
        if (value != null) {
            setter.accept(value);
        }
    }

    public boolean isApplicableFor(ClassInfo beanInfo) {
        return SpringTopicSubscriptionImpl.class.isAssignableFrom(beanInfo.getBean().getClass());
    }

    public void configureFor(ClassInfo beanInfo) {
        LOG.info("Registering Zeebe worker(s) of bean: {}", beanInfo.getBean());
        this.springTopicSubscriptions.put(beanInfo.getBeanName(), (SpringTopicSubscriptionImpl)beanInfo.getBean());
    }

    public void start(ZeebeClient zeebeClient) {
        this.springTopicSubscriptions.forEach((beanName, bean) -> {
            JobWorkerBuilderStep1.JobWorkerBuilderStep3 builder = zeebeClient.newWorker().jobType(bean.getTopicName()).handler((JobHandler)new ExternalTaskHandlerWrapper(bean.getExternalTaskHandler(), Optional.empty())).name(beanName);
            this.setIfPresent(this.calculateLockDuration((SpringTopicSubscriptionImpl)bean), arg_0 -> ((JobWorkerBuilderStep1.JobWorkerBuilderStep3)builder).timeout(arg_0));
            this.setIfPresent(this.clientConfiguration.getMaxTasks(), arg_0 -> ((JobWorkerBuilderStep1.JobWorkerBuilderStep3)builder).maxJobsActive(arg_0));
            this.setIfPresent(this.clientConfiguration.getAsyncResponseTimeout(), timeout -> builder.pollInterval(Duration.ofMillis(timeout)));
            this.setIfPresent(bean.getVariableNames(), arg_0 -> ((JobWorkerBuilderStep1.JobWorkerBuilderStep3)builder).fetchVariables(arg_0));
            this.setIfPresent(this.clientConfiguration.getAsyncResponseTimeout(), timeout -> builder.requestTimeout(Duration.ofMillis(timeout)));
            this.openedWorkers.add(builder.open());
        });
    }

    public void stop(ZeebeClient zeebeClient) {
        this.openedWorkers.forEach(JobWorker::close);
    }
}

