/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.adapter.worker;

import io.camunda.zeebe.client.api.command.CompleteJobCommandStep1;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.worker.JobClient;
import io.camunda.zeebe.spring.client.annotation.JobWorker;
import io.camunda.zeebe.spring.client.exception.ZeebeBpmnError;
import java.util.HashMap;
import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.community.migration.adapter.execution.ZeebeJobDelegateExecution;
import org.camunda.community.migration.adapter.execution.variable.VariableTyper;
import org.camunda.community.migration.adapter.juel.ClassResolver;
import org.camunda.community.migration.adapter.juel.JuelExpressionResolver;
import org.springframework.stereotype.Component;

@Component
public class CamundaPlatform7DelegationWorker {
    private final JuelExpressionResolver expressionResolver;
    private final ClassResolver classResolver;
    private final VariableTyper variableTyper;

    public CamundaPlatform7DelegationWorker(JuelExpressionResolver expressionResolver, ClassResolver classResolver, VariableTyper variableTyper) {
        this.expressionResolver = expressionResolver;
        this.classResolver = classResolver;
        this.variableTyper = variableTyper;
    }

    @JobWorker(type="camunda-7-adapter", autoComplete=false)
    public void delegateToCamundaPlatformCode(JobClient client, ActivatedJob job) throws Exception {
        String delegateClass = (String)job.getCustomHeaders().get("class");
        String delegateExpression = (String)job.getCustomHeaders().get("delegateExpression");
        String expression = (String)job.getCustomHeaders().get("expression");
        String resultVariable = (String)job.getCustomHeaders().get("resultVariable");
        String startListener = (String)job.getCustomHeaders().get("executionListener.start");
        String endListener = (String)job.getCustomHeaders().get("executionListener.end");
        ZeebeJobDelegateExecution execution = new ZeebeJobDelegateExecution(job, this.variableTyper);
        try {
            ExecutionListener executionListener;
            if (delegateClass == null && delegateExpression == null && expression == null) {
                throw new RuntimeException("Either 'class' or 'delegateExpression' or 'expression' must be specified in task headers for job :" + job);
            }
            if (startListener != null) {
                executionListener = (ExecutionListener)this.expressionResolver.evaluate(startListener, execution);
                executionListener.notify((DelegateExecution)execution);
            }
            if (delegateClass != null) {
                javaDelegate = this.classResolver.loadJavaDelegate(delegateClass);
                javaDelegate.execute((DelegateExecution)execution);
            } else if (delegateExpression != null) {
                javaDelegate = (JavaDelegate)this.expressionResolver.evaluate(delegateExpression, execution);
                javaDelegate.execute((DelegateExecution)execution);
            } else if (expression != null) {
                Object result = this.expressionResolver.evaluate(expression, execution);
                if (resultVariable != null) {
                    execution.setVariable(resultVariable, result);
                }
            }
            if (endListener != null) {
                executionListener = (ExecutionListener)this.expressionResolver.evaluate(endListener, execution);
                executionListener.notify((DelegateExecution)execution);
            }
            CompleteJobCommandStep1 completeCommand = client.newCompleteCommand(job.getKey());
            completeCommand.variables(execution.getVariables());
            completeCommand.send().join();
        }
        catch (BpmnError e) {
            throw new ZeebeBpmnError(e.getErrorCode(), e.getMessage() == null ? "" : e.getMessage(), new HashMap());
        }
    }
}

