/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.detector.rules;

import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.ViolationHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.camunda.community.migration.detector.rules.CodeMigrationReport;

public abstract class AbstractCodeMigrationReportDecoratingViolationHandler<T>
implements ViolationHandler<T> {
    private final CodeMigrationReport codeMigrationReport;
    private final ArchRule archRule;

    public AbstractCodeMigrationReportDecoratingViolationHandler(CodeMigrationReport codeMigrationReport, ArchRule archRule) {
        this.codeMigrationReport = codeMigrationReport;
        this.archRule = archRule;
    }

    private JavaClass getFileClass(JavaClass clazz) {
        return clazz.getEnclosingClass().map(this::getFileClass).orElse(clazz);
    }

    public void handle(Collection<T> violatingObjects, String message) {
        violatingObjects.forEach(violatingObject -> {
            if (this.handledClass().isAssignableFrom(violatingObject.getClass())) {
                CodeMigrationReport.CodeMigrationReportForClass codeMigrationReportForClass = this.codeMigrationReport.classes().computeIfAbsent(this.getFileClass(this.extractJavaClass(violatingObject)).getFullName(), c -> new CodeMigrationReport.CodeMigrationReportForClass(new HashMap<String, List<CodeMigrationReport.CodeMigrationReportForClass.CodeMigrationReportForRule>>()));
                List codeMigrationReportForRules = codeMigrationReportForClass.rules().computeIfAbsent(this.archRule.getDescription(), c -> new ArrayList());
                codeMigrationReportForRules.add(new CodeMigrationReport.CodeMigrationReportForClass.CodeMigrationReportForRule(message));
            }
        });
    }

    protected abstract JavaClass extractJavaClass(T var1);

    protected abstract Class<T> handledClass();
}

