/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.detector.rules;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaAccess;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.properties.HasOwner;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import org.camunda.community.migration.detector.rules.Camunda7MigrationConditions;
import org.camunda.community.migration.detector.rules.Camunda7MigrationPredicates;

public class Camunda7MigrationRules {
    public static ArchRule ensureNoImplementationOfCamunda7Interfaces() {
        return ArchRuleDefinition.noClasses().should(Camunda7MigrationConditions.implementCamunda7Interface());
    }

    public static ArchRule ensureNoSpringBootEvents() {
        return ArchRuleDefinition.noMethods().that(Camunda7MigrationPredicates.isSpringEventListener()).should(Camunda7MigrationConditions.haveCamunda7ParameterTypes());
    }

    public static ArchRule ensureNoInvocationOfCamunda7Api() {
        return ArchRuleDefinition.noClasses().should().callMethodWhere(JavaAccess.Predicates.target((DescribedPredicate)HasOwner.Predicates.With.owner((DescribedPredicate)JavaClass.Predicates.assignableTo(Camunda7MigrationPredicates.camunda7Api()))));
    }
}

