/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.detector.rules;

import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaMethodCall;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.EvaluationResult;
import com.tngtech.archunit.lang.ViolationHandler;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.camunda.community.migration.detector.rules.CodeMigrationReport;
import org.camunda.community.migration.detector.rules.JavaClassViolationHandler;
import org.camunda.community.migration.detector.rules.JavaMethodCallViolationHandler;
import org.camunda.community.migration.detector.rules.JavaMethodViolationHandler;

public class CodeMigrationReportBuilder {
    private final JavaClasses javaClasses;
    private final CodeMigrationReport codeMigrationReport = new CodeMigrationReport(new HashMap<String, CodeMigrationReport.CodeMigrationReportForClass>());
    private final AtomicBoolean built = new AtomicBoolean(false);

    public CodeMigrationReportBuilder(JavaClasses javaClasses) {
        this.javaClasses = javaClasses;
    }

    public CodeMigrationReportBuilder withArchRule(ArchRule archRule) {
        EvaluationResult evaluationResult = archRule.evaluate(this.javaClasses);
        this.getViolationHandlers(archRule).forEach(violationHandler -> evaluationResult.handleViolations(violationHandler, new Object[0]));
        return this;
    }

    public CodeMigrationReport build() {
        return this.codeMigrationReport;
    }

    private Set<ViolationHandler<?>> getViolationHandlers(ArchRule archRule) {
        return Set.of(this.javaClassViolationHandler(archRule), this.javaMethodViolationHandler(archRule), this.javaMethodCallViolationHandler(archRule));
    }

    private ViolationHandler<JavaClass> javaClassViolationHandler(ArchRule archRule) {
        return new JavaClassViolationHandler(this.codeMigrationReport, archRule);
    }

    private ViolationHandler<JavaMethod> javaMethodViolationHandler(ArchRule archRule) {
        return new JavaMethodViolationHandler(this.codeMigrationReport, archRule);
    }

    private ViolationHandler<JavaMethodCall> javaMethodCallViolationHandler(ArchRule archRule) {
        return new JavaMethodCallViolationHandler(this.codeMigrationReport, archRule);
    }
}

