/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.detector.rules;

import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import java.util.HashSet;
import java.util.stream.Collectors;

public class Camunda7MigrationConditions {
    public static ArchCondition<JavaMethod> haveCamunda7ParameterTypes() {
        return new ArchCondition<JavaMethod>("have camunda 7 parameter types", new Object[0]){

            public void check(JavaMethod item, ConditionEvents events) {
                for (JavaClass parameterType : item.getRawParameterTypes()) {
                    if (!Camunda7MigrationConditions.isCamunda7Code(parameterType)) continue;
                    events.add(SimpleConditionEvent.satisfied((Object)item, (String)String.format("Parameter type %s comes from camunda 7", parameterType.getName())));
                }
            }
        };
    }

    public static ArchCondition<JavaClass> implementCamunda7Interface() {
        return new ArchCondition<JavaClass>("implement camunda 7 interface", new Object[0]){

            public void check(JavaClass javaClass, ConditionEvents conditionEvents) {
                HashSet interfaces = new HashSet();
                interfaces.addAll(javaClass.getAllRawInterfaces());
                interfaces.addAll(javaClass.getAllRawSuperclasses().stream().flatMap(jc -> jc.getAllRawInterfaces().stream()).collect(Collectors.toSet()));
                HashSet<JavaClass> violationCandidates = new HashSet<JavaClass>();
                for (JavaClass interFace : interfaces) {
                    if (!Camunda7MigrationConditions.isCamunda7Code(interFace)) continue;
                    violationCandidates.add(interFace);
                }
                for (JavaClass interFace : violationCandidates) {
                    conditionEvents.add(SimpleConditionEvent.satisfied((Object)javaClass, (String)String.format("Class <%s> does implement <%s> in %s", javaClass.getName(), interFace.getName(), javaClass.getSourceCodeLocation())));
                }
            }
        };
    }

    private static boolean isCamunda7Code(JavaClass javaClass) {
        return javaClass.getPackageName().startsWith("org.camunda.bpm");
    }
}

