/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.detector.rules;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaAccess;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.properties.HasOwner;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.DecisionService;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.FilterService;
import org.camunda.bpm.engine.FormService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.community.migration.detector.rules.HasMethod;
import org.camunda.community.migration.detector.rules.IsSpringListener;

public class Camunda7MigrationRules {
    public static ArchRule ensureNoTaskListener() {
        return ArchRuleDefinition.noClasses().should().implement(TaskListener.class);
    }

    public static ArchRule ensureNoExecutionListener() {
        return ArchRuleDefinition.noClasses().should().implement(ExecutionListener.class);
    }

    public static ArchRule ensureNoJavaDelegate() {
        return ArchRuleDefinition.noClasses().should().implement(JavaDelegate.class);
    }

    public static ArchRule ensureNoSpringEventTaskListeners() {
        return ArchRuleDefinition.noClasses().should((ArchCondition)new HasMethod(new IsSpringListener<DelegateTask>(DelegateTask.class)));
    }

    public static ArchRule ensureNoSpringEventExecutionListeners() {
        return ArchRuleDefinition.noClasses().should((ArchCondition)new HasMethod(new IsSpringListener<DelegateExecution>(DelegateExecution.class)));
    }

    public static ArchRule ensureNoSpringEventHistoryEventListeners() {
        return ArchRuleDefinition.noClasses().should((ArchCondition)new HasMethod(new IsSpringListener<HistoryEvent>(HistoryEvent.class)));
    }

    public static ArchRule ensureNoInvocationOfRepositoryService() {
        return ArchRuleDefinition.noClasses().should().callMethodWhere(JavaAccess.Predicates.target((DescribedPredicate)HasOwner.Predicates.With.owner((DescribedPredicate)JavaClass.Predicates.assignableTo(RepositoryService.class))));
    }

    public static ArchRule ensureNoInvocationOfRuntimeService() {
        return ArchRuleDefinition.noClasses().should().callMethodWhere(JavaAccess.Predicates.target((DescribedPredicate)HasOwner.Predicates.With.owner((DescribedPredicate)JavaClass.Predicates.assignableTo(RuntimeService.class))));
    }

    public static ArchRule ensureNoInvocationOfTaskService() {
        return ArchRuleDefinition.noClasses().should().callMethodWhere(JavaAccess.Predicates.target((DescribedPredicate)HasOwner.Predicates.With.owner((DescribedPredicate)JavaClass.Predicates.assignableTo(TaskService.class))));
    }

    public static ArchRule ensureNoInvocationOfIdentityService() {
        return ArchRuleDefinition.noClasses().should().callMethodWhere(JavaAccess.Predicates.target((DescribedPredicate)HasOwner.Predicates.With.owner((DescribedPredicate)JavaClass.Predicates.assignableTo(IdentityService.class))));
    }

    public static ArchRule ensureNoInvocationOfFormService() {
        return ArchRuleDefinition.noClasses().should().callMethodWhere(JavaAccess.Predicates.target((DescribedPredicate)HasOwner.Predicates.With.owner((DescribedPredicate)JavaClass.Predicates.assignableTo(FormService.class))));
    }

    public static ArchRule ensureNoInvocationOfHistoryService() {
        return ArchRuleDefinition.noClasses().should().callMethodWhere(JavaAccess.Predicates.target((DescribedPredicate)HasOwner.Predicates.With.owner((DescribedPredicate)JavaClass.Predicates.assignableTo(HistoryService.class))));
    }

    public static ArchRule ensureNoInvocationOfManagementService() {
        return ArchRuleDefinition.noClasses().should().callMethodWhere(JavaAccess.Predicates.target((DescribedPredicate)HasOwner.Predicates.With.owner((DescribedPredicate)JavaClass.Predicates.assignableTo(ManagementService.class))));
    }

    public static ArchRule ensureNoInvocationOfFilterService() {
        return ArchRuleDefinition.noClasses().should().callMethodWhere(JavaAccess.Predicates.target((DescribedPredicate)HasOwner.Predicates.With.owner((DescribedPredicate)JavaClass.Predicates.assignableTo(FilterService.class))));
    }

    public static ArchRule ensureNoInvocationOfExternalTaskService() {
        return ArchRuleDefinition.noClasses().should().callMethodWhere(JavaAccess.Predicates.target((DescribedPredicate)HasOwner.Predicates.With.owner((DescribedPredicate)JavaClass.Predicates.assignableTo(ExternalTaskService.class))));
    }

    public static ArchRule ensureNoInvocationOfDecisionService() {
        return ArchRuleDefinition.noClasses().should().callMethodWhere(JavaAccess.Predicates.target((DescribedPredicate)HasOwner.Predicates.With.owner((DescribedPredicate)JavaClass.Predicates.assignableTo(DecisionService.class))));
    }

    public static ArchRule ensureNoInvocationOfCaseService() {
        return ArchRuleDefinition.noClasses().should().callMethodWhere(JavaAccess.Predicates.target((DescribedPredicate)HasOwner.Predicates.With.owner((DescribedPredicate)JavaClass.Predicates.assignableTo(CaseService.class))));
    }
}

