/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.detector.rules;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaMethod;
import org.springframework.context.event.EventListener;

public class IsSpringListener<T>
extends DescribedPredicate<JavaMethod> {
    private final Class<T> eventType;

    public IsSpringListener(Class<T> eventType) {
        super("is a Spring Event Listener for " + eventType.getName(), new Object[0]);
        this.eventType = eventType;
    }

    public boolean test(JavaMethod javaMethod) {
        return javaMethod.isAnnotatedWith(EventListener.class) && javaMethod.getRawParameterTypes().stream().anyMatch(clazz -> this.eventType.isAssignableFrom(clazz.reflect()));
    }
}

